/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.internal.diagnostics.StoreLatencyPlugin;
import com.hazelcast.internal.util.Timer;
import java.util.Map;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;

public class LatencyTrackingCacheLoader<K, V>
implements CacheLoader<K, V> {
    static final String KEY = "CacheLoaderLatency";
    private final CacheLoader<K, V> delegate;
    private final StoreLatencyPlugin.LatencyProbe loadProbe;
    private final StoreLatencyPlugin.LatencyProbe loadAllProbe;

    public LatencyTrackingCacheLoader(CacheLoader<K, V> delegate, StoreLatencyPlugin plugin, String cacheName) {
        this.delegate = delegate;
        this.loadProbe = plugin.newProbe(KEY, cacheName, "load");
        this.loadAllProbe = plugin.newProbe(KEY, cacheName, "loadAll");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(K k) throws CacheLoaderException {
        long startNanos = Timer.nanos();
        try {
            Object object = this.delegate.load(k);
            return (V)object;
        }
        finally {
            this.loadProbe.recordValue(Timer.nanosElapsed(startNanos));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<K, V> loadAll(Iterable<? extends K> iterable) throws CacheLoaderException {
        long startNanos = Timer.nanos();
        try {
            Map map = this.delegate.loadAll(iterable);
            return map;
        }
        finally {
            this.loadAllProbe.recordValue(Timer.nanosElapsed(startNanos));
        }
    }
}

