/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.converter.BigDecimalConverter;
import com.hazelcast.sql.impl.type.converter.BigIntegerConverter;
import com.hazelcast.sql.impl.type.converter.BooleanConverter;
import com.hazelcast.sql.impl.type.converter.ByteConverter;
import com.hazelcast.sql.impl.type.converter.CalendarConverter;
import com.hazelcast.sql.impl.type.converter.CharacterConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import com.hazelcast.sql.impl.type.converter.DateConverter;
import com.hazelcast.sql.impl.type.converter.DoubleConverter;
import com.hazelcast.sql.impl.type.converter.FloatConverter;
import com.hazelcast.sql.impl.type.converter.InstantConverter;
import com.hazelcast.sql.impl.type.converter.IntegerConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateConverter;
import com.hazelcast.sql.impl.type.converter.LocalDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.LocalTimeConverter;
import com.hazelcast.sql.impl.type.converter.LongConverter;
import com.hazelcast.sql.impl.type.converter.NullConverter;
import com.hazelcast.sql.impl.type.converter.ObjectConverter;
import com.hazelcast.sql.impl.type.converter.OffsetDateTimeConverter;
import com.hazelcast.sql.impl.type.converter.ShortConverter;
import com.hazelcast.sql.impl.type.converter.StringConverter;
import com.hazelcast.sql.impl.type.converter.ZonedDateTimeConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class Converters {
    private static final int MAX_CONVERTER_COUNT = 100;
    private static final Converter[] CONVERTERS;
    private static final Map<Class<?>, Converter> CLASS_TO_CONVERTER;

    private Converters() {
    }

    public static Converter getConverter(int converterId) {
        if (converterId < CONVERTERS.length) {
            return CONVERTERS[converterId];
        }
        throw QueryException.error("Converter with ID " + converterId + " doesn't exist");
    }

    public static Converter getConverter(Class<?> clazz) {
        Converter res = CLASS_TO_CONVERTER.get(clazz);
        if (res == null) {
            res = Calendar.class.isAssignableFrom(clazz) ? CalendarConverter.INSTANCE : ObjectConverter.INSTANCE;
        }
        return res;
    }

    public static List<Converter> getConverters() {
        return Arrays.asList(CONVERTERS);
    }

    private static List<Converter> prepareConverters() {
        ArrayList<Converter> converters = new ArrayList<Converter>();
        converters.add(BooleanConverter.INSTANCE);
        converters.add(ByteConverter.INSTANCE);
        converters.add(ShortConverter.INSTANCE);
        converters.add(IntegerConverter.INSTANCE);
        converters.add(LongConverter.INSTANCE);
        converters.add(BigIntegerConverter.INSTANCE);
        converters.add(BigDecimalConverter.INSTANCE);
        converters.add(FloatConverter.INSTANCE);
        converters.add(DoubleConverter.INSTANCE);
        converters.add(CharacterConverter.INSTANCE);
        converters.add(StringConverter.INSTANCE);
        converters.add(DateConverter.INSTANCE);
        converters.add(CalendarConverter.INSTANCE);
        converters.add(LocalDateConverter.INSTANCE);
        converters.add(LocalTimeConverter.INSTANCE);
        converters.add(LocalDateTimeConverter.INSTANCE);
        converters.add(InstantConverter.INSTANCE);
        converters.add(OffsetDateTimeConverter.INSTANCE);
        converters.add(ZonedDateTimeConverter.INSTANCE);
        converters.add(ObjectConverter.INSTANCE);
        converters.add(NullConverter.INSTANCE);
        return converters;
    }

    private static Map<Class<?>, Converter> createConvertersMap(List<Converter> converters) {
        HashMap res = new HashMap(converters.size());
        for (Converter converter : converters) {
            Class<?> valueClass = converter.getValueClass();
            if (valueClass == null) continue;
            Converter prevConverter = res.put(valueClass, converter);
            if (prevConverter != null) {
                throw new HazelcastException("Duplicate converter for class [class=" + valueClass + ", converter1=" + prevConverter.getValueClass().getName() + ", converter2=" + valueClass.getName() + ']');
            }
            Class<?> primitiveValueClass = Converters.getPrimitiveClass(valueClass);
            if (primitiveValueClass == null) continue;
            res.put(primitiveValueClass, converter);
        }
        return res;
    }

    private static Converter[] createConvertersArray(List<Converter> converters) {
        TreeMap<Integer, Converter> map = new TreeMap<Integer, Converter>();
        for (Converter converter : converters) {
            Converter oldConverter = map.put(converter.getId(), converter);
            if (oldConverter == null) continue;
            throw new HazelcastException("Two converters has the same ID [id=" + converter.getId() + ", converter1=" + oldConverter.getClass().getSimpleName() + ", converter2=" + converter.getClass().getSimpleName() + ']');
        }
        int maxId = (Integer)map.lastKey();
        if (maxId > 100) {
            throw new HazelcastException("Converter ID cannot be greater than 100: " + ((Converter)map.lastEntry().getValue()).getClass().getSimpleName());
        }
        Converter[] res = new Converter[maxId + 1];
        for (int i = 0; i <= maxId; ++i) {
            Converter converter = (Converter)map.get(i);
            if (converter == null) {
                throw new HazelcastException("Converter with ID " + i + " is not defined");
            }
            res[i] = converter;
        }
        return res;
    }

    private static Class<?> getPrimitiveClass(Class<?> targetClass) {
        if (targetClass == Boolean.class) {
            return Boolean.TYPE;
        }
        if (targetClass == Byte.class) {
            return Byte.TYPE;
        }
        if (targetClass == Short.class) {
            return Short.TYPE;
        }
        if (targetClass == Character.class) {
            return Character.TYPE;
        }
        if (targetClass == Integer.class) {
            return Integer.TYPE;
        }
        if (targetClass == Long.class) {
            return Long.TYPE;
        }
        if (targetClass == Float.class) {
            return Float.TYPE;
        }
        if (targetClass == Double.class) {
            return Double.TYPE;
        }
        if (targetClass == Void.class) {
            return Void.TYPE;
        }
        return null;
    }

    static {
        List<Converter> converters = Converters.prepareConverters();
        CONVERTERS = Converters.createConvertersArray(converters);
        CLASS_TO_CONVERTER = Converters.createConvertersMap(converters);
    }
}

