/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.calcite.opt.physical.visitor;

import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.sql.SqlFunction;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.fun.SqlTrimFunction;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.calcite.SqlToQueryType;
import com.hazelcast.sql.impl.calcite.validate.HazelcastSqlOperatorTable;
import com.hazelcast.sql.impl.expression.CastExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.SymbolExpression;
import com.hazelcast.sql.impl.expression.math.AbsFunction;
import com.hazelcast.sql.impl.expression.math.DivideFunction;
import com.hazelcast.sql.impl.expression.math.DoubleFunction;
import com.hazelcast.sql.impl.expression.math.FloorCeilFunction;
import com.hazelcast.sql.impl.expression.math.MinusFunction;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.expression.math.PlusFunction;
import com.hazelcast.sql.impl.expression.math.RandFunction;
import com.hazelcast.sql.impl.expression.math.RoundTruncateFunction;
import com.hazelcast.sql.impl.expression.math.SignFunction;
import com.hazelcast.sql.impl.expression.math.UnaryMinusFunction;
import com.hazelcast.sql.impl.expression.predicate.AndPredicate;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotFalsePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNotTruePredicate;
import com.hazelcast.sql.impl.expression.predicate.IsNullPredicate;
import com.hazelcast.sql.impl.expression.predicate.IsTruePredicate;
import com.hazelcast.sql.impl.expression.predicate.NotPredicate;
import com.hazelcast.sql.impl.expression.predicate.OrPredicate;
import com.hazelcast.sql.impl.expression.string.AsciiFunction;
import com.hazelcast.sql.impl.expression.string.CharLengthFunction;
import com.hazelcast.sql.impl.expression.string.ConcatFunction;
import com.hazelcast.sql.impl.expression.string.InitcapFunction;
import com.hazelcast.sql.impl.expression.string.LikeFunction;
import com.hazelcast.sql.impl.expression.string.LowerFunction;
import com.hazelcast.sql.impl.expression.string.SubstringFunction;
import com.hazelcast.sql.impl.expression.string.TrimFunction;
import com.hazelcast.sql.impl.expression.string.UpperFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;

public final class RexToExpression {
    private RexToExpression() {
    }

    public static Expression<?> convertLiteral(RexLiteral literal) {
        SqlTypeName type = literal.getType().getSqlTypeName();
        switch (type) {
            case BOOLEAN: {
                return RexToExpression.convertBooleanLiteral(literal, type);
            }
            case TINYINT: 
            case SMALLINT: 
            case INTEGER: 
            case BIGINT: 
            case DECIMAL: 
            case REAL: 
            case FLOAT: 
            case DOUBLE: {
                return RexToExpression.convertNumericLiteral(literal, type);
            }
            case CHAR: 
            case VARCHAR: {
                return RexToExpression.convertStringLiteral(literal, type);
            }
            case NULL: {
                return ConstantExpression.create(null, QueryDataType.NULL);
            }
            case ANY: {
                assert (literal.getValueAs(Object.class) == null);
                return ConstantExpression.create(null, QueryDataType.OBJECT);
            }
            case SYMBOL: {
                return SymbolExpression.create(literal.getValue());
            }
        }
        throw QueryException.error("Unsupported literal: " + literal);
    }

    public static Expression<?> convertCall(RexCall call, Expression<?>[] operands) {
        SqlOperator operator = call.getOperator();
        QueryDataType resultType = SqlToQueryType.map(call.getType().getSqlTypeName());
        switch (operator.getKind()) {
            case DEFAULT: {
                return ConstantExpression.create(null, resultType);
            }
            case CAST: {
                if (operands[0].getType().equals(resultType)) {
                    return operands[0];
                }
                return CastExpression.create(operands[0], resultType);
            }
            case AND: {
                return AndPredicate.create(operands);
            }
            case OR: {
                return OrPredicate.create(operands);
            }
            case NOT: {
                return NotPredicate.create(operands[0]);
            }
            case PLUS: {
                return PlusFunction.create(operands[0], operands[1], resultType);
            }
            case MINUS: {
                return MinusFunction.create(operands[0], operands[1], resultType);
            }
            case TIMES: {
                return MultiplyFunction.create(operands[0], operands[1], resultType);
            }
            case DIVIDE: {
                return DivideFunction.create(operands[0], operands[1], resultType);
            }
            case MINUS_PREFIX: {
                return UnaryMinusFunction.create(operands[0], resultType);
            }
            case PLUS_PREFIX: {
                return operands[0];
            }
            case FLOOR: {
                return FloorCeilFunction.create(operands[0], resultType, false);
            }
            case CEIL: {
                return FloorCeilFunction.create(operands[0], resultType, true);
            }
            case EQUALS: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.EQUALS);
            }
            case NOT_EQUALS: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.NOT_EQUALS);
            }
            case GREATER_THAN: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.GREATER_THAN);
            }
            case GREATER_THAN_OR_EQUAL: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.GREATER_THAN_OR_EQUAL);
            }
            case LESS_THAN: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.LESS_THAN);
            }
            case LESS_THAN_OR_EQUAL: {
                return ComparisonPredicate.create(operands[0], operands[1], ComparisonMode.LESS_THAN_OR_EQUAL);
            }
            case IS_TRUE: {
                return IsTruePredicate.create(operands[0]);
            }
            case IS_NOT_TRUE: {
                return IsNotTruePredicate.create(operands[0]);
            }
            case IS_FALSE: {
                return IsFalsePredicate.create(operands[0]);
            }
            case IS_NOT_FALSE: {
                return IsNotFalsePredicate.create(operands[0]);
            }
            case IS_NULL: {
                return IsNullPredicate.create(operands[0]);
            }
            case IS_NOT_NULL: {
                return IsNotNullPredicate.create(operands[0]);
            }
            case LIKE: {
                Expression<?> escape = operands.length == 2 ? null : operands[2];
                return LikeFunction.create(operands[0], operands[1], escape);
            }
            case TRIM: {
                assert (operands.length == 3);
                assert (operands[0] instanceof SymbolExpression);
                SqlTrimFunction.Flag trimFlag = (SqlTrimFunction.Flag)((Object)((SymbolExpression)operands[0]).getSymbol());
                return TrimFunction.create(operands[2], operands[1], trimFlag.getLeft() == 1, trimFlag.getRight() == 1);
            }
            case OTHER: {
                if (operator != HazelcastSqlOperatorTable.CONCAT) break;
                assert (operands.length == 2);
                return ConcatFunction.create(operands[0], operands[1]);
            }
            case OTHER_FUNCTION: {
                SqlFunction function = (SqlFunction)operator;
                if (function == HazelcastSqlOperatorTable.COS) {
                    return DoubleFunction.create(operands[0], 0);
                }
                if (function == HazelcastSqlOperatorTable.SIN) {
                    return DoubleFunction.create(operands[0], 1);
                }
                if (function == HazelcastSqlOperatorTable.TAN) {
                    return DoubleFunction.create(operands[0], 2);
                }
                if (function == HazelcastSqlOperatorTable.COT) {
                    return DoubleFunction.create(operands[0], 3);
                }
                if (function == HazelcastSqlOperatorTable.ACOS) {
                    return DoubleFunction.create(operands[0], 4);
                }
                if (function == HazelcastSqlOperatorTable.ASIN) {
                    return DoubleFunction.create(operands[0], 5);
                }
                if (function == HazelcastSqlOperatorTable.ATAN) {
                    return DoubleFunction.create(operands[0], 6);
                }
                if (function == HazelcastSqlOperatorTable.EXP) {
                    return DoubleFunction.create(operands[0], 7);
                }
                if (function == HazelcastSqlOperatorTable.LN) {
                    return DoubleFunction.create(operands[0], 8);
                }
                if (function == HazelcastSqlOperatorTable.LOG10) {
                    return DoubleFunction.create(operands[0], 9);
                }
                if (function == HazelcastSqlOperatorTable.RAND) {
                    return RandFunction.create(operands.length == 0 ? null : operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.ABS) {
                    return AbsFunction.create(operands[0], resultType);
                }
                if (function == SqlStdOperatorTable.PI) {
                    return ConstantExpression.create(Math.PI, resultType);
                }
                if (function == HazelcastSqlOperatorTable.SIGN) {
                    return SignFunction.create(operands[0], resultType);
                }
                if (function == HazelcastSqlOperatorTable.DEGREES) {
                    return DoubleFunction.create(operands[0], 10);
                }
                if (function == HazelcastSqlOperatorTable.RADIANS) {
                    return DoubleFunction.create(operands[0], 11);
                }
                if (function == HazelcastSqlOperatorTable.ROUND) {
                    return RoundTruncateFunction.create(operands[0], operands.length == 1 ? null : operands[1], resultType, false);
                }
                if (function == HazelcastSqlOperatorTable.TRUNCATE) {
                    return RoundTruncateFunction.create(operands[0], operands.length == 1 ? null : operands[1], resultType, true);
                }
                if (function == HazelcastSqlOperatorTable.CHAR_LENGTH || function == HazelcastSqlOperatorTable.CHARACTER_LENGTH || function == HazelcastSqlOperatorTable.LENGTH) {
                    return CharLengthFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.UPPER) {
                    return UpperFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.LOWER) {
                    return LowerFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.INITCAP) {
                    return InitcapFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.ASCII) {
                    return AsciiFunction.create(operands[0]);
                }
                if (function == HazelcastSqlOperatorTable.SUBSTRING) {
                    Expression<?> input = operands[0];
                    Expression<?> start = operands[1];
                    Expression<?> length = operands.length > 2 ? operands[2] : null;
                    return SubstringFunction.create(input, start, length);
                }
                if (function == HazelcastSqlOperatorTable.LTRIM) {
                    return TrimFunction.create(operands[0], null, true, false);
                }
                if (function == HazelcastSqlOperatorTable.RTRIM) {
                    return TrimFunction.create(operands[0], null, false, true);
                }
                if (function != HazelcastSqlOperatorTable.BTRIM) break;
                return TrimFunction.create(operands[0], null, true, true);
            }
        }
        throw QueryException.error("Unsupported operator: " + operator);
    }

    private static Expression<?> convertBooleanLiteral(RexLiteral literal, SqlTypeName type) {
        assert (type == SqlTypeName.BOOLEAN);
        Boolean value = literal.getValueAs(Boolean.class);
        return ConstantExpression.create(value, SqlToQueryType.map(type));
    }

    private static Expression<?> convertNumericLiteral(RexLiteral literal, SqlTypeName type) {
        Number value;
        switch (type) {
            case TINYINT: {
                value = literal.getValueAs(Byte.class);
                break;
            }
            case SMALLINT: {
                value = literal.getValueAs(Short.class);
                break;
            }
            case INTEGER: {
                value = literal.getValueAs(Integer.class);
                break;
            }
            case BIGINT: {
                BigDecimal decimalValue = literal.getValueAs(BigDecimal.class);
                value = decimalValue == null ? null : Long.valueOf(decimalValue.longValue());
                break;
            }
            case DECIMAL: {
                value = literal.getValueAs(BigDecimal.class);
                break;
            }
            case REAL: {
                value = literal.getValueAs(Float.class);
                break;
            }
            case DOUBLE: {
                value = literal.getValueAs(Double.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported literal type: " + (Object)((Object)type));
            }
        }
        return ConstantExpression.create(value, SqlToQueryType.map(type));
    }

    private static Expression<?> convertStringLiteral(RexLiteral literal, SqlTypeName type) {
        String value;
        switch (type) {
            case CHAR: 
            case VARCHAR: {
                value = literal.getValueAs(String.class);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported literal type: " + (Object)((Object)type));
            }
        }
        return ConstantExpression.create(value, SqlToQueryType.map(type));
    }
}

