/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql.fun;

import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.org.apache.calcite.sql.SqlCall;
import com.hazelcast.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlNode;
import com.hazelcast.org.apache.calcite.sql.SqlSpecialOperator;
import com.hazelcast.org.apache.calcite.sql.SqlWriter;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidator;
import com.hazelcast.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.List;

public class SqlSequenceValueOperator
extends SqlSpecialOperator {
    SqlSequenceValueOperator(SqlKind kind) {
        super(kind.name(), kind, 100);
        assert (kind == SqlKind.NEXT_VALUE || kind == SqlKind.CURRENT_VALUE);
    }

    @Override
    public boolean isDeterministic() {
        return false;
    }

    @Override
    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        writer.sep(this.kind == SqlKind.NEXT_VALUE ? "NEXT VALUE FOR" : "CURRENT VALUE FOR");
        call.getOperandList().get(0).unparse(writer, 0, 0);
    }

    @Override
    public RelDataType deriveType(SqlValidator validator, SqlValidatorScope scope, SqlCall call) {
        RelDataTypeFactory typeFactory = validator.getTypeFactory();
        return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.BIGINT), false);
    }

    @Override
    public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
        List<SqlNode> operands = call.getOperandList();
        assert (operands.size() == 1);
        assert (operands.get(0) instanceof SqlIdentifier);
        SqlIdentifier id = (SqlIdentifier)operands.get(0);
        validator.validateSequenceValue(scope, id);
    }
}

