/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.MigrationCycleOperation;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.impl.Versioned;
import java.io.IOException;

public final class PartitionStateCheckOperation
extends AbstractPartitionOperation
implements MigrationCycleOperation,
Versioned {
    private long stamp;
    @Deprecated
    private int version;
    private transient boolean stale;

    public PartitionStateCheckOperation() {
    }

    public PartitionStateCheckOperation(long stamp, @Deprecated int version) {
        this.stamp = stamp;
        this.version = version;
    }

    @Override
    public void run() {
        ILogger logger = this.getLogger();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        if (this.getNodeEngine().getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V4_1)) {
            long currentStamp = partitionService.getPartitionStateStamp();
            if (currentStamp != this.stamp) {
                this.stale = true;
                if (logger.isFineEnabled()) {
                    logger.fine("Partition table is stale! Current stamp: " + currentStamp + ", master stamp: " + this.stamp);
                }
            }
        } else {
            int currentVersion = partitionService.getPartitionStateVersion();
            if (currentVersion < this.version) {
                this.stale = true;
                if (logger.isFineEnabled()) {
                    logger.fine("Partition table is stale! Current version: " + currentVersion + ", master version: " + this.version);
                }
            }
        }
    }

    @Override
    public Object getResponse() {
        return !this.stale;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        if (in.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            this.stamp = in.readLong();
        } else {
            this.version = in.readInt();
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (out.getVersion().isGreaterOrEqual(Versions.V4_1)) {
            out.writeLong(this.stamp);
        } else {
            out.writeInt(this.version);
        }
    }

    @Override
    public int getClassId() {
        return 21;
    }
}

