/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientLocalBackupListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AddBackupListenerMessageTask
extends AbstractAddListenerMessageTask<Void>
implements Consumer<Long> {
    public AddBackupListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected boolean acceptOnIncompleteStart() {
        return true;
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        UUID uuid = this.endpoint.getUuid();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Client is adding backup listener. client uuid " + uuid);
        }
        this.clientEngine.addBackupListener(uuid, this);
        return InternalCompletableFuture.newCompletedFuture(uuid);
    }

    @Override
    protected void addDestroyAction(UUID registrationId) {
        this.endpoint.addDestroyAction(registrationId, () -> this.clientEngine.deregisterBackupListener(registrationId));
    }

    @Override
    public void accept(Long backupCorrelationId) {
        ClientMessage eventMessage = ClientLocalBackupListenerCodec.encodeBackupEvent(backupCorrelationId);
        eventMessage.getStartFrame().flags |= 0x80;
        this.sendClientMessage(eventMessage);
    }

    @Override
    protected Void decodeClientMessage(ClientMessage clientMessage) {
        return null;
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientLocalBackupListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

