/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.EvictionConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.IndexConfigCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ListenerConfigHolderCodec;
import com.hazelcast.client.impl.protocol.codec.custom.PredicateConfigHolderCodec;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.EvictionConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.ListenerConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.PredicateConfigHolder;
import com.hazelcast.client.impl.protocol.task.dynamicconfig.QueryCacheConfigHolder;
import com.hazelcast.config.IndexConfig;
import java.util.List;

public final class QueryCacheConfigHolderCodec {
    private static final int BATCH_SIZE_FIELD_OFFSET = 0;
    private static final int BUFFER_SIZE_FIELD_OFFSET = 4;
    private static final int DELAY_SECONDS_FIELD_OFFSET = 8;
    private static final int INCLUDE_VALUE_FIELD_OFFSET = 12;
    private static final int POPULATE_FIELD_OFFSET = 13;
    private static final int COALESCE_FIELD_OFFSET = 14;
    private static final int INITIAL_FRAME_SIZE = 15;

    private QueryCacheConfigHolderCodec() {
    }

    public static void encode(ClientMessage clientMessage, QueryCacheConfigHolder queryCacheConfigHolder) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[15]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, queryCacheConfigHolder.getBatchSize());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 4, queryCacheConfigHolder.getBufferSize());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 8, queryCacheConfigHolder.getDelaySeconds());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 12, queryCacheConfigHolder.isIncludeValue());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, queryCacheConfigHolder.isPopulate());
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 14, queryCacheConfigHolder.isCoalesce());
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, queryCacheConfigHolder.getInMemoryFormat());
        StringCodec.encode(clientMessage, queryCacheConfigHolder.getName());
        PredicateConfigHolderCodec.encode(clientMessage, queryCacheConfigHolder.getPredicateConfigHolder());
        EvictionConfigHolderCodec.encode(clientMessage, queryCacheConfigHolder.getEvictionConfigHolder());
        ListMultiFrameCodec.encodeNullable(clientMessage, queryCacheConfigHolder.getListenerConfigs(), ListenerConfigHolderCodec::encode);
        ListMultiFrameCodec.encodeNullable(clientMessage, queryCacheConfigHolder.getIndexConfigs(), IndexConfigCodec::encode);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static QueryCacheConfigHolder decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        int bufferSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 4);
        int delaySeconds = FixedSizeTypesCodec.decodeInt(initialFrame.content, 8);
        boolean includeValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 12);
        boolean populate = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
        boolean coalesce = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 14);
        String inMemoryFormat = StringCodec.decode(iterator);
        String name = StringCodec.decode(iterator);
        PredicateConfigHolder predicateConfigHolder = PredicateConfigHolderCodec.decode(iterator);
        EvictionConfigHolder evictionConfigHolder = EvictionConfigHolderCodec.decode(iterator);
        List<ListenerConfigHolder> listenerConfigs = ListMultiFrameCodec.decodeNullable(iterator, ListenerConfigHolderCodec::decode);
        List<IndexConfig> indexConfigs = ListMultiFrameCodec.decodeNullable(iterator, IndexConfigCodec::decode);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new QueryCacheConfigHolder(batchSize, bufferSize, delaySeconds, includeValue, populate, coalesce, inMemoryFormat, name, predicateConfigHolder, evictionConfigHolder, listenerConfigs, indexConfigs);
    }
}

