/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.impl.operationservice.Operation;

public class OutboundOperationHandler {
    private final Address thisAddress;
    private final InternalSerializationService serializationService;
    private final Node node;

    public OutboundOperationHandler(Node node, Address thisAddress, InternalSerializationService serializationService) {
        this.node = node;
        this.thisAddress = thisAddress;
        this.serializationService = serializationService;
    }

    public boolean send(Operation op, Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", op: " + op);
        }
        int streamId = op.getPartitionId();
        return this.node.getServer().getConnectionManager(EndpointQualifier.MEMBER).transmit(this.toPacket(op), target, streamId);
    }

    public boolean send(Operation op, ServerConnection connection) {
        Packet packet = this.toPacket(op);
        return connection.write(packet);
    }

    private Packet toPacket(Operation op) {
        byte[] bytes = this.serializationService.toBytes(op);
        int partitionId = op.getPartitionId();
        Packet packet = new Packet(bytes, partitionId).setPacketType(Packet.Type.OPERATION);
        if (op.isUrgent()) {
            packet.raiseFlags(16);
        }
        return packet;
    }
}

