/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.LongArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class RingbufferReadManyCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1509632;
    public static final int RESPONSE_MESSAGE_TYPE = 1509633;
    private static final int REQUEST_START_SEQUENCE_FIELD_OFFSET = 16;
    private static final int REQUEST_MIN_COUNT_FIELD_OFFSET = 24;
    private static final int REQUEST_MAX_COUNT_FIELD_OFFSET = 28;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 32;
    private static final int RESPONSE_READ_COUNT_FIELD_OFFSET = 13;
    private static final int RESPONSE_NEXT_SEQ_FIELD_OFFSET = 17;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 25;

    private RingbufferReadManyCodec() {
    }

    public static ClientMessage encodeRequest(String name, long startSequence, int minCount, int maxCount, @Nullable Data filter) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Ringbuffer.ReadMany");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[32], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1509632);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, startSequence);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, minCount);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, maxCount);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, filter, DataCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.startSequence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.minCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.maxCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.name = StringCodec.decode(iterator);
        request.filter = CodecUtil.decodeNullable(iterator, DataCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse(int readCount, Collection<Data> items, @Nullable long[] itemSeqs, long nextSeq) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[25], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1509633);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 13, readCount);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 17, nextSeq);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, items, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, itemSeqs, LongArrayCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.readCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 13);
        response.nextSeq = FixedSizeTypesCodec.decodeLong(initialFrame.content, 17);
        response.items = ListMultiFrameCodec.decode(iterator, DataCodec::decode);
        response.itemSeqs = CodecUtil.decodeNullable(iterator, LongArrayCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public int readCount;
        public List<Data> items;
        @Nullable
        public long[] itemSeqs;
        public long nextSeq;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public long startSequence;
        public int minCount;
        public int maxCount;
        @Nullable
        public Data filter;
    }
}

