/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.dto;

import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.util.JsonUtil;
import com.hazelcast.json.internal.JsonSerializable;
import java.util.EnumMap;

public class AdvancedNetworkStatsDTO
implements JsonSerializable {
    private final EnumMap<ProtocolType, Long> bytesTransceived = new EnumMap(ProtocolType.class);

    public void incBytesTransceived(ProtocolType type, long bytes) {
        Long prev = this.bytesTransceived.get((Object)type);
        this.bytesTransceived.put(type, prev != null ? prev + bytes : bytes);
    }

    public long getBytesTransceived(ProtocolType type) {
        Long bytes = this.bytesTransceived.get((Object)type);
        return bytes != null ? bytes : 0L;
    }

    @Override
    public JsonObject toJson() {
        JsonObject bytesTransceivedJson = new JsonObject();
        for (ProtocolType type : ProtocolType.valuesAsSet()) {
            bytesTransceivedJson.add(type.name(), this.getBytesTransceived(type));
        }
        JsonObject result = new JsonObject();
        result.add("bytesTransceived", bytesTransceivedJson);
        return result;
    }

    @Override
    public void fromJson(JsonObject json) {
        JsonObject bytesTransceivedJson = JsonUtil.getObject(json, "bytesTransceived", null);
        if (bytesTransceivedJson != null) {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                this.bytesTransceived.put(type, bytesTransceivedJson.getLong(type.name(), 0L));
            }
        }
    }

    public String toString() {
        return "AdvancedNetworkStatsDTO{bytesTransceived=" + this.bytesTransceived + '}';
    }
}

