/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class ManagementCenterConfig {
    private boolean scriptingEnabled;
    private final Set<String> trustedInterfaces = Collections.newSetFromMap(new ConcurrentHashMap());

    public ManagementCenterConfig setScriptingEnabled(boolean scriptingEnabled) {
        this.scriptingEnabled = scriptingEnabled;
        return this;
    }

    public boolean isScriptingEnabled() {
        return this.scriptingEnabled;
    }

    public Set<String> getTrustedInterfaces() {
        return this.trustedInterfaces;
    }

    public ManagementCenterConfig setTrustedInterfaces(Set<String> interfaces) {
        Preconditions.isNotNull(interfaces, "interfaces");
        this.trustedInterfaces.clear();
        this.trustedInterfaces.addAll(interfaces);
        return this;
    }

    public ManagementCenterConfig addTrustedInterface(String ip) {
        this.trustedInterfaces.add(Preconditions.isNotNull(ip, "ip"));
        return this;
    }

    public String toString() {
        return "ManagementCenterConfig{scriptingEnabled=" + this.scriptingEnabled + "trustedInterfaces=" + this.trustedInterfaces + "}";
    }

    public int hashCode() {
        return Objects.hash(this.scriptingEnabled, this.trustedInterfaces);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManagementCenterConfig other = (ManagementCenterConfig)obj;
        return this.scriptingEnabled == other.scriptingEnabled && Objects.equals(this.trustedInterfaces, other.trustedInterfaces);
    }
}

