/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetSystemPropertiesCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetSystemPropertiesMessageTask
extends AbstractCallableMessageTask<MCGetSystemPropertiesCodec.RequestParameters> {
    public GetSystemPropertiesMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() throws Exception {
        return System.getProperties().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, String>(Objects.toString(e.getKey()), Objects.toString(e.getValue()))).collect(Collectors.toList());
    }

    @Override
    protected MCGetSystemPropertiesCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCGetSystemPropertiesCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCGetSystemPropertiesCodec.encodeResponse((Collection)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getSystemProperties";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }

    @Override
    public boolean isManagementTask() {
        return true;
    }
}

