/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.request;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.cache.ICache;
import com.hazelcast.cache.impl.CacheEntryProcessorEntry;
import com.hazelcast.com.eclipsesource.json.JsonObject;
import com.hazelcast.instance.HazelcastInstanceCacheManager;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.request.ConsoleRequest;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.util.JsonUtil;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.MutableEntry;

public class GetCacheEntryRequest
implements ConsoleRequest {
    private static final GetCacheEntryViewEntryProcessor ENTRY_PROCESSOR = new GetCacheEntryViewEntryProcessor();
    private String cacheName;
    private String type;
    private String key;

    public GetCacheEntryRequest() {
    }

    public GetCacheEntryRequest(String type, String cacheName, String key) {
        this.type = type;
        this.cacheName = cacheName;
        this.key = key;
    }

    @Override
    public int getType() {
        return 41;
    }

    @Override
    public void writeResponse(ManagementCenterService mcs, JsonObject root) throws Exception {
        InternalSerializationService serializationService = mcs.getHazelcastInstance().getSerializationService();
        HazelcastInstanceCacheManager cacheManager = mcs.getHazelcastInstance().getCacheManager();
        ICache cache = cacheManager.getCache(this.cacheName);
        CacheEntryView cacheEntry = null;
        if ("string".equals(this.type)) {
            cacheEntry = (CacheEntryView)cache.invoke(this.key, ENTRY_PROCESSOR, new Object[]{cacheEntry});
        } else if ("long".equals(this.type)) {
            cacheEntry = (CacheEntryView)cache.invoke(Long.valueOf(this.key), ENTRY_PROCESSOR, new Object[]{cacheEntry});
        } else if ("integer".equals(this.type)) {
            cacheEntry = (CacheEntryView)cache.invoke(Integer.valueOf(this.key), ENTRY_PROCESSOR, new Object[]{cacheEntry});
        }
        JsonObject result = new JsonObject();
        if (cacheEntry != null) {
            Object value = serializationService.toObject(cacheEntry.getValue());
            result.add("cacheBrowse_value", value != null ? value.toString() : "null");
            result.add("cacheBrowse_class", value != null ? value.getClass().getName() : "null");
            result.add("date_cache_creation_time", Long.toString(cacheEntry.getCreationTime()));
            result.add("date_cache_expiration_time", Long.toString(cacheEntry.getExpirationTime()));
            result.add("cacheBrowse_hits", Long.toString(cacheEntry.getAccessHit()));
            result.add("date_cache_access_time", Long.toString(cacheEntry.getLastAccessTime()));
        }
        root.add("result", result);
    }

    @Override
    public void fromJson(JsonObject json) {
        this.cacheName = JsonUtil.getString(json, "cacheName");
        this.type = JsonUtil.getString(json, "type");
        this.key = JsonUtil.getString(json, "key");
    }

    private static class GetCacheEntryViewEntryProcessor
    implements EntryProcessor<Object, Object, CacheEntryView> {
        private GetCacheEntryViewEntryProcessor() {
        }

        public CacheEntryView process(MutableEntry mutableEntry, Object ... objects) throws EntryProcessorException {
            CacheEntryProcessorEntry entry = (CacheEntryProcessorEntry)mutableEntry;
            final Object record = entry.getRecord();
            CacheEntryView<Object, Object> cacheEntryView = new CacheEntryView<Object, Object>(){

                @Override
                public String getKey() {
                    return null;
                }

                @Override
                public Object getValue() {
                    return record.getValue();
                }

                @Override
                public long getExpirationTime() {
                    return record.getExpirationTime();
                }

                @Override
                public long getCreationTime() {
                    return record.getCreationTime();
                }

                @Override
                public long getLastAccessTime() {
                    return record.getLastAccessTime();
                }

                @Override
                public long getAccessHit() {
                    return record.getAccessHit();
                }
            };
            return cacheEntryView;
        }
    }
}

