/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.InitialMembershipEvent;
import com.hazelcast.core.InitialMembershipListener;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.hotrestart.HotRestartService;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.LifecycleServiceImpl;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.cluster.impl.ClusterClockImpl;
import com.hazelcast.internal.cluster.impl.ClusterHeartbeatManager;
import com.hazelcast.internal.cluster.impl.ClusterJoinManager;
import com.hazelcast.internal.cluster.impl.ClusterMergeTask;
import com.hazelcast.internal.cluster.impl.ClusterStateChange;
import com.hazelcast.internal.cluster.impl.ClusterStateManager;
import com.hazelcast.internal.cluster.impl.MemberMap;
import com.hazelcast.internal.cluster.impl.MemberSelectingCollection;
import com.hazelcast.internal.cluster.impl.MembersView;
import com.hazelcast.internal.cluster.impl.MembersViewMetadata;
import com.hazelcast.internal.cluster.impl.MembershipManager;
import com.hazelcast.internal.cluster.impl.MembershipManagerCompat;
import com.hazelcast.internal.cluster.impl.SplitBrainHandler;
import com.hazelcast.internal.cluster.impl.operations.ExplicitSuspicionOp;
import com.hazelcast.internal.cluster.impl.operations.MemberRemoveOperation;
import com.hazelcast.internal.cluster.impl.operations.OnJoinOp;
import com.hazelcast.internal.cluster.impl.operations.PromoteLiteMemberOp;
import com.hazelcast.internal.cluster.impl.operations.ShutdownNodeOp;
import com.hazelcast.internal.cluster.impl.operations.TriggerExplicitSuspicionOp;
import com.hazelcast.internal.cluster.impl.operations.TriggerMemberListPublishOp;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MemberAttributeServiceEvent;
import com.hazelcast.spi.MembershipAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Preconditions;
import com.hazelcast.util.UuidUtil;
import com.hazelcast.util.executor.ExecutorType;
import com.hazelcast.version.Version;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterServiceImpl
implements ClusterService,
ConnectionListener,
ManagedService,
EventPublishingService<MembershipEvent, MembershipListener>,
TransactionalService {
    public static final String SERVICE_NAME = "hz:core:clusterService";
    static final String EXECUTOR_NAME = "hz:cluster";
    static final String MEMBERSHIP_EVENT_EXECUTOR_NAME = "hz:cluster:event";
    private static final int DEFAULT_MERGE_RUN_DELAY_MILLIS = 100;
    private static final int CLUSTER_EXECUTOR_QUEUE_CAPACITY = 1000;
    private static final long CLUSTER_SHUTDOWN_SLEEP_DURATION_IN_MILLIS = 1000L;
    private static final boolean ASSERTION_ENABLED = ClusterServiceImpl.class.desiredAssertionStatus();
    private final ReentrantLock lock = new ReentrantLock();
    private final Node node;
    private final NodeEngineImpl nodeEngine;
    private final ILogger logger;
    private final ClusterClockImpl clusterClock;
    private final MembershipManager membershipManager;
    private final MembershipManagerCompat membershipManagerCompat;
    private final ClusterStateManager clusterStateManager;
    private final ClusterJoinManager clusterJoinManager;
    private final ClusterHeartbeatManager clusterHeartbeatManager;
    private final AtomicBoolean joined = new AtomicBoolean(false);
    private final boolean useLegacyMemberListFormat;
    private volatile MemberImpl localMember;
    private volatile Address masterAddress;
    private volatile String clusterId;

    public ClusterServiceImpl(Node node, MemberImpl localMember) {
        this.node = node;
        this.localMember = localMember;
        this.nodeEngine = node.nodeEngine;
        this.logger = node.getLogger(ClusterService.class.getName());
        this.clusterClock = new ClusterClockImpl(this.logger);
        this.useLegacyMemberListFormat = node.getProperties().getBoolean(GroupProperty.USE_LEGACY_MEMBER_LIST_FORMAT);
        this.membershipManager = new MembershipManager(node, this, this.lock);
        this.membershipManagerCompat = new MembershipManagerCompat(node, this, this.lock);
        this.clusterStateManager = new ClusterStateManager(node, this.lock);
        this.clusterJoinManager = new ClusterJoinManager(node, this, this.lock);
        this.clusterHeartbeatManager = new ClusterHeartbeatManager(node, this, this.lock);
        node.connectionManager.addConnectionListener(this);
        this.nodeEngine.getExecutionService().register(MEMBERSHIP_EVENT_EXECUTOR_NAME, 1, Integer.MAX_VALUE, ExecutorType.CACHED);
        this.registerMetrics();
    }

    private void registerMetrics() {
        MetricsRegistry metricsRegistry = this.node.nodeEngine.getMetricsRegistry();
        metricsRegistry.scanAndRegister(this.clusterClock, "cluster.clock");
        metricsRegistry.scanAndRegister(this.clusterHeartbeatManager, "cluster.heartbeat");
        metricsRegistry.scanAndRegister(this, "cluster");
    }

    @Override
    public void init(NodeEngine nodeEngine, Properties properties) {
        long mergeFirstRunDelayMs = this.node.getProperties().getMillis(GroupProperty.MERGE_FIRST_RUN_DELAY_SECONDS);
        mergeFirstRunDelayMs = mergeFirstRunDelayMs > 0L ? mergeFirstRunDelayMs : 100L;
        ExecutionService executionService = nodeEngine.getExecutionService();
        executionService.register(EXECUTOR_NAME, 2, 1000, ExecutorType.CACHED);
        long mergeNextRunDelayMs = this.node.getProperties().getMillis(GroupProperty.MERGE_NEXT_RUN_DELAY_SECONDS);
        mergeNextRunDelayMs = mergeNextRunDelayMs > 0L ? mergeNextRunDelayMs : 100L;
        executionService.scheduleWithRepetition(EXECUTOR_NAME, new SplitBrainHandler(this.node), mergeFirstRunDelayMs, mergeNextRunDelayMs, TimeUnit.MILLISECONDS);
        this.membershipManager.init();
        this.clusterHeartbeatManager.init();
    }

    public void sendLocalMembershipEvent() {
        this.membershipManager.sendMembershipEvents(Collections.<MemberImpl>emptySet(), Collections.singleton(this.getLocalMember()));
    }

    public void handleExplicitSuspicion(MembersViewMetadata expectedMembersViewMetadata, Address suspectedAddress) {
        this.membershipManager.handleExplicitSuspicion(expectedMembersViewMetadata, suspectedAddress);
    }

    public void handleExplicitSuspicionTrigger(Address caller, int callerMemberListVersion, MembersViewMetadata suspectedMembersViewMetadata) {
        this.membershipManager.handleExplicitSuspicionTrigger(caller, callerMemberListVersion, suspectedMembersViewMetadata);
    }

    public void suspectMember(Member suspectedMember, String reason, boolean destroyConnection) {
        if (this.getClusterVersion().isGreaterOrEqual(Versions.V3_9)) {
            this.membershipManager.suspectMember((MemberImpl)suspectedMember, reason, destroyConnection);
        } else {
            this.membershipManagerCompat.removeMember(suspectedMember.getAddress(), suspectedMember.getUuid(), reason);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspectAddressIfNotConnected(Address address) {
        this.lock.lock();
        try {
            MemberImpl member = this.getMember(address);
            if (member == null) {
                this.logger.fine("Cannot suspect " + address + ", since it's not a member.");
                return;
            }
            Connection conn = this.node.getConnectionManager().getConnection(address);
            if (conn != null && conn.isAlive()) {
                this.logger.fine("Cannot suspect " + member + ", since there's a live connection -> " + conn);
                return;
            }
            this.suspectMember(member, "No connection", false);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMasterConfirmation(MembersViewMetadata membersViewMetadata, long timestamp) {
        this.lock.lock();
        try {
            if (!this.isJoined()) {
                this.logger.warning("Ignoring master confirmation of sender: " + membersViewMetadata + " because not joined!");
                return;
            }
            Address endpoint = membersViewMetadata.getMemberAddress();
            MemberImpl member = this.membershipManager.getMember(endpoint, membersViewMetadata.getMemberUuid());
            if (member == null) {
                if (this.getClusterVersion().isGreaterOrEqual(Versions.V3_9)) {
                    if (!this.isMaster()) {
                        this.logger.warning(endpoint + " has sent MasterConfirmation with " + membersViewMetadata + ", but this node is not master!");
                        return;
                    }
                    if (this.clusterJoinManager.isMastershipClaimInProgress()) {
                        return;
                    }
                    this.logger.warning(endpoint + " has sent MasterConfirmation with " + membersViewMetadata + ", but it is not a member of this cluster!");
                    this.sendExplicitSuspicion(membersViewMetadata);
                    for (Member m : this.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR)) {
                        this.sendExplicitSuspicionTrigger(m.getAddress(), membersViewMetadata);
                    }
                } else {
                    this.sendExplicitSuspicion(membersViewMetadata);
                }
            } else if (this.isMaster()) {
                this.clusterHeartbeatManager.acceptMasterConfirmation(member, timestamp);
            } else {
                this.logger.warning(endpoint + " has sent MasterConfirmation with " + membersViewMetadata + ", but this node is not master!");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    void sendExplicitSuspicion(MembersViewMetadata endpointMembersViewMetadata) {
        Address endpoint = endpointMembersViewMetadata.getMemberAddress();
        if (endpoint.equals(this.node.getThisAddress())) {
            this.logger.warning("Cannot send explicit suspicion for " + endpointMembersViewMetadata + " to itself.");
            return;
        }
        if (!this.isJoined()) {
            this.logger.fine("Cannot send explicit suspicion, not joined yet!");
            return;
        }
        Version clusterVersion = this.getClusterVersion();
        assert (!clusterVersion.isUnknown()) : "Cluster version should not be unknown after join!";
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        if (clusterVersion.isGreaterOrEqual(Versions.V3_9)) {
            ExplicitSuspicionOp op = new ExplicitSuspicionOp(endpointMembersViewMetadata);
            operationService.send(op, endpoint);
        } else {
            operationService.send(new MemberRemoveOperation(this.getThisAddress()), endpoint);
        }
    }

    void sendExplicitSuspicionTrigger(Address triggerTo, MembersViewMetadata endpointMembersViewMetadata) {
        if (triggerTo.equals(this.node.getThisAddress())) {
            this.logger.warning("Cannot send explicit suspicion trigger for " + endpointMembersViewMetadata + " to itself.");
            return;
        }
        int memberListVersion = this.membershipManager.getMemberListVersion();
        TriggerExplicitSuspicionOp op = new TriggerExplicitSuspicionOp(memberListVersion, endpointMembersViewMetadata);
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        operationService.send(op, triggerTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembersView handleMastershipClaim(Address candidateAddress, String candidateUuid) {
        Preconditions.checkNotNull(candidateAddress);
        Preconditions.checkNotNull(candidateUuid);
        Preconditions.checkFalse(this.getThisAddress().equals(candidateAddress), "cannot accept my own mastership claim!");
        this.lock.lock();
        try {
            Preconditions.checkTrue(this.isJoined(), candidateAddress + " claims mastership but this node is not joined!");
            Preconditions.checkFalse(this.isMaster(), candidateAddress + " claims mastership but this node is master!");
            Preconditions.checkFalse(candidateAddress.equals(this.getMasterAddress()), candidateAddress + " claims mastership but it is already the known master!");
            MemberImpl masterCandidate = this.membershipManager.getMember(candidateAddress, candidateUuid);
            Preconditions.checkTrue(masterCandidate != null, candidateAddress + " claims mastership but it is not a member!");
            MemberMap memberMap = this.membershipManager.getMemberMap();
            if (!this.shouldAcceptMastership(memberMap, masterCandidate)) {
                String message = "Cannot accept mastership claim of " + candidateAddress + " at the moment. There are more suitable master candidates in the member list.";
                this.logger.fine(message);
                throw new RetryableHazelcastException(message);
            }
            if (!this.membershipManager.clearMemberSuspicion(candidateAddress, "Mastership claim")) {
                throw new IllegalStateException("Cannot accept mastership claim of " + candidateAddress + ". " + this.getMasterAddress() + " is already master.");
            }
            this.setMasterAddress(masterCandidate.getAddress());
            Set<MemberImpl> members = memberMap.tailMemberSet(masterCandidate, true);
            MembersView response = MembersView.createNew(memberMap.getVersion(), members);
            this.logger.warning("Mastership of " + candidateAddress + " is accepted. Response: " + response);
            MembersView membersView = response;
            return membersView;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean shouldAcceptMastership(MemberMap memberMap, MemberImpl candidate) {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        for (MemberImpl member : memberMap.headMemberSet(candidate, false)) {
            if (this.membershipManager.isMemberSuspected(member.getAddress())) continue;
            this.logger.fine("Should not accept mastership claim of " + candidate + ", because " + member + " is not suspected at the moment and is before than " + candidate + " in the member list.");
            return false;
        }
        return true;
    }

    public void merge(Address newTargetAddress) {
        this.node.getJoiner().setTargetAddress(newTargetAddress);
        LifecycleServiceImpl lifecycleService = this.node.hazelcastInstance.getLifecycleService();
        lifecycleService.runUnderLifecycleLock(new ClusterMergeTask(this.node));
    }

    @Override
    public void reset() {
        this.lock.lock();
        try {
            this.resetLocalMemberUuid();
            this.resetClusterId();
            this.clearInternalState();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void resetLocalMemberUuid() {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        assert (!this.isJoined()) : "Cannot reset local member uuid when joined.";
        Address address = this.getThisAddress();
        String newUuid = UuidUtil.createMemberUuid(address);
        this.logger.warning("Resetting local member uuid. Previous: " + this.localMember.getUuid() + ", new: " + newUuid);
        boolean liteMember = this.localMember.isLiteMember();
        Map<String, Object> memberAttributes = this.localMember.getAttributes();
        this.localMember = new MemberImpl(address, this.localMember.getVersion(), true, newUuid, memberAttributes, liteMember, this.node.hazelcastInstance);
        this.node.loggingService.setThisMember(this.localMember);
    }

    public void resetJoinState() {
        this.lock.lock();
        try {
            this.setMasterAddress(null);
            this.setJoined(false);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean finalizeJoin(MembersView membersView, Address callerAddress, String callerUuid, String clusterId, ClusterState clusterState, Version clusterVersion, long clusterStartTime, long masterTime, OnJoinOp preJoinOp) {
        this.lock.lock();
        try {
            if (!this.checkValidMaster(callerAddress)) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Not finalizing join because caller: " + callerAddress + " is not known master: " + this.getMasterAddress());
                }
                MembersViewMetadata membersViewMetadata = new MembersViewMetadata(callerAddress, callerUuid, callerAddress, membersView.getVersion());
                this.sendExplicitSuspicion(membersViewMetadata);
                boolean bl = false;
                return bl;
            }
            if (this.isJoined()) {
                if (this.logger.isFineEnabled()) {
                    this.logger.fine("Node is already joined... No need to finalize join...");
                }
                boolean membersViewMetadata = false;
                return membersViewMetadata;
            }
            this.assertMemberUpdateContainsLocalMember(membersView);
            this.initialClusterState(clusterState, clusterVersion);
            this.setClusterId(clusterId);
            ClusterClockImpl clusterClock = this.getClusterClock();
            clusterClock.setClusterStartTime(clusterStartTime);
            clusterClock.setMasterTime(masterTime);
            if (preJoinOp != null) {
                this.nodeEngine.getOperationService().run(preJoinOp);
            }
            this.membershipManager.updateMembers(membersView);
            this.clusterHeartbeatManager.heartbeat();
            this.setJoined(true);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMembers(MembersView membersView, Address callerAddress, String callerUuid) {
        this.lock.lock();
        try {
            if (!this.isJoined()) {
                this.logger.warning("Not updating members received from caller: " + callerAddress + " because node is not joined! ");
                boolean bl = false;
                return bl;
            }
            if (!this.checkValidMaster(callerAddress)) {
                this.logger.warning("Not updating members because caller: " + callerAddress + " is not known master: " + this.getMasterAddress());
                MembersViewMetadata callerMembersViewMetadata = new MembersViewMetadata(callerAddress, callerUuid, callerAddress, membersView.getVersion());
                if (!this.clusterJoinManager.isMastershipClaimInProgress()) {
                    this.sendExplicitSuspicion(callerMembersViewMetadata);
                }
                boolean bl = false;
                return bl;
            }
            this.assertMemberUpdateContainsLocalMember(membersView);
            if (!this.shouldProcessMemberUpdate(membersView)) {
                boolean bl = false;
                return bl;
            }
            this.membershipManager.updateMembers(membersView);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertMemberUpdateContainsLocalMember(MembersView membersView) {
        if (!ASSERTION_ENABLED) {
            return;
        }
        MemberImpl localMember = this.getLocalMember();
        assert (membersView.containsMember(localMember.getAddress(), localMember.getUuid())) : "Not applying member update because member list doesn't contain us! -> " + membersView + ", local member: " + localMember;
    }

    private boolean checkValidMaster(Address callerAddress) {
        return callerAddress != null && callerAddress.equals(this.getMasterAddress());
    }

    void repairPartitionTableIfReturningMember(MemberImpl member) {
        Address oldAddress;
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        if (!this.isMaster()) {
            return;
        }
        if (this.getClusterState().isMigrationAllowed()) {
            return;
        }
        if (!this.node.getNodeExtension().isStartCompleted()) {
            return;
        }
        Address address = member.getAddress();
        MemberImpl memberRemovedWhileClusterIsNotActive = this.membershipManager.getMemberRemovedInNotJoinableState(member.getUuid());
        if (memberRemovedWhileClusterIsNotActive != null && !(oldAddress = memberRemovedWhileClusterIsNotActive.getAddress()).equals(address)) {
            assert (!this.isMemberRemovedInNotJoinableState(address));
            this.logger.warning(member + " is returning with a new address. Old one was: " + oldAddress + ". Will update partition table with the new address.");
            InternalPartitionServiceImpl partitionService = this.node.partitionService;
            partitionService.replaceAddress(oldAddress, address);
        }
    }

    private boolean shouldProcessMemberUpdate(MembersView membersView) {
        if (this.getClusterVersion().isLessThan(Versions.V3_9)) {
            return this.shouldProcessMemberUpdate(this.membershipManager.getMemberMap(), membersView.getMembers());
        }
        int memberListVersion = this.membershipManager.getMemberListVersion();
        if (memberListVersion > membersView.getVersion()) {
            this.logger.fine("Received an older member update, ignoring... Current version: " + memberListVersion + ", Received version: " + membersView.getVersion());
            return false;
        }
        if (memberListVersion == membersView.getVersion()) {
            if (ASSERTION_ENABLED) {
                MemberMap memberMap = this.membershipManager.getMemberMap();
                Collection<Address> currentAddresses = memberMap.getAddresses();
                Set<Address> newAddresses = membersView.getAddresses();
                assert (currentAddresses.size() == newAddresses.size() && newAddresses.containsAll(currentAddresses)) : "Member view versions are same but new member view doesn't match the current! Current: " + memberMap.toMembersView() + ", New: " + membersView;
            }
            this.logger.fine("Received a periodic member update, ignoring... Version: " + memberListVersion);
            return false;
        }
        return true;
    }

    @Deprecated
    private boolean shouldProcessMemberUpdate(MemberMap currentMembers, Collection<MemberInfo> newMemberInfos) {
        int currentMembersSize = currentMembers.size();
        int newMembersSize = newMemberInfos.size();
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        if (currentMembersSize > newMembersSize) {
            this.logger.warning("Received an older member update, no need to process...");
            operationService.send(new TriggerMemberListPublishOp(), this.getMasterAddress());
            return false;
        }
        if (currentMembersSize == newMembersSize) {
            Set<MemberInfo> currentMemberInfos = ClusterServiceImpl.createMemberInfoSet(currentMembers.getMembers());
            if (currentMemberInfos.containsAll(newMemberInfos)) {
                this.logger.fine("Received a periodic member update, no need to process...");
            } else {
                this.logger.warning("Received an inconsistent member update which contains new members and removes some of the current members! Ignoring and requesting a new member update...");
                operationService.send(new TriggerMemberListPublishOp(), this.getMasterAddress());
            }
            return false;
        }
        Set<MemberInfo> currentMemberInfos = ClusterServiceImpl.createMemberInfoSet(currentMembers.getMembers());
        currentMemberInfos.removeAll(newMemberInfos);
        if (currentMemberInfos.isEmpty()) {
            return true;
        }
        this.logger.warning("Received an inconsistent member update. It has more members but also removes some of the current members! Ignoring and requesting a new member update...");
        operationService.send(new TriggerMemberListPublishOp(), this.getMasterAddress());
        return false;
    }

    private static Set<MemberInfo> createMemberInfoSet(Collection<MemberImpl> members) {
        HashSet<MemberInfo> memberInfos = new HashSet<MemberInfo>();
        for (MemberImpl member : members) {
            memberInfos.add(new MemberInfo(member));
        }
        return memberInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMemberAttribute(String uuid, MemberAttributeOperationType operationType, String key, Object value) {
        this.lock.lock();
        try {
            for (MemberImpl member : this.membershipManager.getMembers()) {
                if (!member.getUuid().equals(uuid)) continue;
                if (!member.equals(this.getLocalMember())) {
                    member.updateAttribute(operationType, key, value);
                }
                this.sendMemberAttributeEvent(member, operationType, key, value);
                break;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connectionAdded(Connection connection) {
    }

    @Override
    public void connectionRemoved(Connection connection) {
        Address masterAddress;
        if (this.logger.isFineEnabled()) {
            this.logger.fine("Removed connection to " + connection.getEndPoint());
        }
        if (!this.isJoined() && (masterAddress = this.getMasterAddress()) != null && masterAddress.equals(connection.getEndPoint())) {
            this.setMasterAddressToJoin(null);
        }
    }

    public NodeEngineImpl getNodeEngine() {
        return this.nodeEngine;
    }

    public boolean isMemberRemovedInNotJoinableState(Address target) {
        return this.membershipManager.isMemberRemovedInNotJoinableState(target);
    }

    boolean isMemberRemovedInNotJoinableState(String uuid) {
        return this.membershipManager.isMemberRemovedInNotJoinableState(uuid);
    }

    public Collection<Member> getCurrentMembersAndMembersRemovedInNotJoinableState() {
        return this.membershipManager.getCurrentMembersAndMembersRemovedInNotJoinableState();
    }

    public void notifyForRemovedMember(MemberImpl member) {
        this.lock.lock();
        try {
            this.membershipManager.onMemberRemove(member);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void shrinkMembersRemovedInNotJoinableState(Collection<String> memberUuidsToRemove) {
        this.membershipManager.shrinkMembersRemovedInNotJoinableState(memberUuidsToRemove);
    }

    private void sendMemberAttributeEvent(MemberImpl member, MemberAttributeOperationType operationType, String key, Object value) {
        final MemberAttributeServiceEvent event = new MemberAttributeServiceEvent((Cluster)this, member, operationType, key, value);
        MemberAttributeEvent attributeEvent = new MemberAttributeEvent(this, member, operationType, key, value);
        Collection<MembershipAwareService> membershipAwareServices = this.nodeEngine.getServices(MembershipAwareService.class);
        if (membershipAwareServices != null && !membershipAwareServices.isEmpty()) {
            for (final MembershipAwareService service : membershipAwareServices) {
                this.nodeEngine.getExecutionService().execute("hz:system", new Runnable(){

                    @Override
                    public void run() {
                        service.memberAttributeChanged(event);
                    }
                });
            }
        }
        InternalEventService eventService = this.nodeEngine.getEventService();
        Collection<EventRegistration> registrations = eventService.getRegistrations(SERVICE_NAME, SERVICE_NAME);
        for (EventRegistration reg : registrations) {
            eventService.publishEvent(SERVICE_NAME, reg, (Object)attributeEvent, reg.getId().hashCode());
        }
    }

    @Override
    public MemberImpl getMember(Address address) {
        if (address == null) {
            return null;
        }
        return this.membershipManager.getMember(address);
    }

    @Override
    public MemberImpl getMember(String uuid) {
        if (uuid == null) {
            return null;
        }
        return this.membershipManager.getMember(uuid);
    }

    @Override
    public Collection<MemberImpl> getMemberImpls() {
        return this.membershipManager.getMembers();
    }

    public Collection<Address> getMemberAddresses() {
        return this.membershipManager.getMemberMap().getAddresses();
    }

    @Override
    public Set<Member> getMembers() {
        return this.membershipManager.getMemberSet();
    }

    @Override
    public Collection<Member> getMembers(MemberSelector selector) {
        return new MemberSelectingCollection<Member>(this.membershipManager.getMembers(), selector);
    }

    @Override
    public void shutdown(boolean terminate) {
        this.clearInternalState();
    }

    private void clearInternalState() {
        this.lock.lock();
        try {
            this.membershipManager.reset();
            this.clusterHeartbeatManager.reset();
            this.clusterStateManager.reset();
            this.clusterJoinManager.reset();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setMasterAddressToJoin(Address master) {
        this.lock.lock();
        try {
            if (this.isJoined()) {
                Address currentMasterAddress = this.getMasterAddress();
                if (!currentMasterAddress.equals(master)) {
                    this.logger.warning("Cannot set master address to " + master + " because node is already joined! Current master: " + currentMasterAddress);
                } else {
                    this.logger.fine("Master address is already set to " + master);
                }
                boolean bl = false;
                return bl;
            }
            this.setMasterAddress(master);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    void setMasterAddress(Address master) {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        if (master != null && this.logger.isFineEnabled()) {
            this.logger.fine("Setting master address to " + master);
        }
        this.masterAddress = master;
    }

    @Override
    public Address getMasterAddress() {
        return this.masterAddress;
    }

    @Override
    public boolean isMaster() {
        return this.node.getThisAddress().equals(this.masterAddress);
    }

    @Override
    public Address getThisAddress() {
        return this.node.getThisAddress();
    }

    @Override
    public MemberImpl getLocalMember() {
        return this.localMember;
    }

    public String getThisUuid() {
        return this.localMember.getUuid();
    }

    void setJoined(boolean val) {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        this.joined.set(val);
    }

    @Override
    public boolean isJoined() {
        return this.joined.get();
    }

    @Override
    @Probe
    public int getSize() {
        return this.membershipManager.getMemberMap().size();
    }

    @Override
    public int getSize(MemberSelector selector) {
        int size = 0;
        for (MemberImpl member : this.membershipManager.getMembers()) {
            if (!selector.select(member)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public ClusterClockImpl getClusterClock() {
        return this.clusterClock;
    }

    @Override
    public long getClusterTime() {
        return this.clusterClock.getClusterTime();
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    void setClusterId(String newClusterId) {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        assert (this.clusterId == null) : "Cluster ID should be null: " + this.clusterId;
        this.clusterId = newClusterId;
    }

    private void resetClusterId() {
        assert (this.lock.isHeldByCurrentThread()) : "Called without holding cluster service lock!";
        this.clusterId = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addMembershipListener(MembershipListener listener) {
        EventRegistration registration;
        Preconditions.checkNotNull(listener, "listener cannot be null");
        InternalEventService eventService = this.nodeEngine.getEventService();
        if (listener instanceof InitialMembershipListener) {
            this.lock.lock();
            try {
                ((InitialMembershipListener)listener).init(new InitialMembershipEvent(this, this.getMembers()));
                registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
            }
            finally {
                this.lock.unlock();
            }
        } else {
            registration = eventService.registerLocalListener(SERVICE_NAME, SERVICE_NAME, listener);
        }
        return registration.getId();
    }

    @Override
    public boolean removeMembershipListener(String registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId cannot be null");
        InternalEventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, SERVICE_NAME, registrationId);
    }

    @Override
    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"})
    public void dispatchEvent(MembershipEvent event, MembershipListener listener) {
        switch (event.getEventType()) {
            case 1: {
                listener.memberAdded(event);
                break;
            }
            case 2: {
                listener.memberRemoved(event);
                break;
            }
            case 5: {
                MemberAttributeEvent memberAttributeEvent = (MemberAttributeEvent)event;
                listener.memberAttributeChanged(memberAttributeEvent);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled event: " + event);
            }
        }
    }

    private String legacyMemberListString() {
        StringBuilder sb = new StringBuilder("\n\nMembers [");
        Collection<MemberImpl> members = this.getMemberImpls();
        sb.append(members.size());
        sb.append("] {");
        for (Member member : members) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n}\n");
        return sb.toString();
    }

    private String memberListString() {
        MemberMap memberMap = this.membershipManager.getMemberMap();
        Set<MemberImpl> members = memberMap.getMembers();
        StringBuilder sb = new StringBuilder("\n\nMembers {").append("size:").append(members.size()).append(", ").append("ver:").append(memberMap.getVersion()).append("} [");
        for (Member member : members) {
            sb.append("\n\t").append(member);
        }
        sb.append("\n]\n");
        return sb.toString();
    }

    public String getMemberListString() {
        if (this.getClusterVersion().isLessThan(Versions.V3_9) || this.useLegacyMemberListFormat) {
            return this.legacyMemberListString();
        }
        return this.memberListString();
    }

    void printMemberList() {
        this.logger.info(this.getMemberListString());
    }

    @Override
    public ClusterState getClusterState() {
        return this.clusterStateManager.getState();
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(String name, Transaction transaction) {
        throw new UnsupportedOperationException("hz:core:clusterService does not support TransactionalObjects!");
    }

    @Override
    public void rollbackTransaction(String transactionId) {
        this.clusterStateManager.rollbackClusterState(transactionId);
    }

    @Override
    public void changeClusterState(ClusterState newState) {
        this.changeClusterState(newState, false);
    }

    private void changeClusterState(ClusterState newState, boolean isTransient) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(newState), this.membershipManager.getMemberMap(), partitionStateVersion, isTransient);
    }

    @Override
    public void changeClusterState(ClusterState newState, TransactionOptions options) {
        this.changeClusterState(newState, options, false);
    }

    private void changeClusterState(ClusterState newState, TransactionOptions options, boolean isTransient) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(newState), this.membershipManager.getMemberMap(), options, partitionStateVersion, isTransient);
    }

    @Override
    public Version getClusterVersion() {
        return this.clusterStateManager.getClusterVersion();
    }

    @Override
    public HotRestartService getHotRestartService() {
        return this.node.getNodeExtension().getHotRestartService();
    }

    @Override
    public void changeClusterVersion(Version version) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(version), this.membershipManager.getMemberMap(), partitionStateVersion, false);
    }

    @Override
    public void changeClusterVersion(Version version, TransactionOptions options) {
        int partitionStateVersion = this.node.getPartitionService().getPartitionStateVersion();
        this.clusterStateManager.changeClusterState(ClusterStateChange.from(version), this.membershipManager.getMemberMap(), options, partitionStateVersion, false);
    }

    void addMembersRemovedInNotJoinableState(Collection<MemberImpl> members) {
        this.membershipManager.addMembersRemovedInNotJoinableState(members);
    }

    @Override
    public void shutdown() {
        this.shutdownCluster(null);
    }

    @Override
    public void shutdown(TransactionOptions options) {
        this.shutdownCluster(options);
    }

    private void shutdownCluster(TransactionOptions options) {
        if (options == null) {
            this.changeClusterState(ClusterState.PASSIVE, true);
        } else {
            this.changeClusterState(ClusterState.PASSIVE, options, true);
        }
        long timeoutNanos = this.node.getProperties().getNanos(GroupProperty.CLUSTER_SHUTDOWN_TIMEOUT_SECONDS);
        long startNanos = System.nanoTime();
        this.node.getNodeExtension().getInternalHotRestartService().waitPartitionReplicaSyncOnCluster(timeoutNanos, TimeUnit.NANOSECONDS);
        this.shutdownNodes(timeoutNanos -= System.nanoTime() - startNanos);
    }

    private void shutdownNodes(long timeoutNanos) {
        ShutdownNodeOp op = new ShutdownNodeOp();
        this.logger.info("Sending shutting down operations to all members...");
        Collection<Member> members = this.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
        long startTime = System.nanoTime();
        while (System.nanoTime() - startTime < timeoutNanos && !members.isEmpty()) {
            for (Member member : members) {
                this.nodeEngine.getOperationService().send(op, member.getAddress());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.warning("Shutdown sleep interrupted. ", e);
                break;
            }
            members = this.getMembers(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR);
        }
        this.logger.info("Number of other nodes remaining: " + this.getSize(MemberSelectors.NON_LOCAL_MEMBER_SELECTOR) + ". Shutting down itself.");
        HazelcastInstanceImpl hazelcastInstance = this.node.hazelcastInstance;
        hazelcastInstance.getLifecycleService().shutdown();
    }

    private void initialClusterState(ClusterState clusterState, Version version) {
        if (this.isJoined()) {
            throw new IllegalStateException("Cannot set initial state after node joined! -> " + (Object)((Object)clusterState));
        }
        this.clusterStateManager.initialClusterState(clusterState, version);
    }

    public MembershipManager getMembershipManager() {
        return this.membershipManager;
    }

    public ClusterStateManager getClusterStateManager() {
        return this.clusterStateManager;
    }

    public ClusterJoinManager getClusterJoinManager() {
        return this.clusterJoinManager;
    }

    public ClusterHeartbeatManager getClusterHeartbeatManager() {
        return this.clusterHeartbeatManager;
    }

    public MembershipManagerCompat getMembershipManagerCompat() {
        assert (this.getClusterVersion().isLessThan(Versions.V3_9)) : "Cluster version should be less than 3.9";
        return this.membershipManagerCompat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void promoteLocalLiteMember() {
        if (this.getClusterVersion().isLessThan(Versions.V3_9)) {
            throw new UnsupportedOperationException("Lite member promotion is not available!");
        }
        MemberImpl member = this.getLocalMember();
        if (!member.isLiteMember()) {
            throw new IllegalStateException(member + " is not a lite member!");
        }
        MemberImpl master = this.getMasterMember();
        PromoteLiteMemberOp op = new PromoteLiteMemberOp();
        op.setCallerUuid(member.getUuid());
        InternalCompletableFuture future = this.nodeEngine.getOperationService().invokeOnTarget(SERVICE_NAME, op, master.getAddress());
        MembersView view = (MembersView)future.join();
        this.lock.lock();
        try {
            MemberImpl localMemberInMemberList;
            if (!member.getAddress().equals(master.getAddress())) {
                this.updateMembers(view, master.getAddress(), master.getUuid());
            }
            if ((localMemberInMemberList = this.membershipManager.getMember(member.getAddress())).isLiteMember()) {
                throw new IllegalStateException("Cannot promote to data member! Previous master was: " + master.getAddress() + ", Current master is: " + this.getMasterAddress());
            }
            this.localMember = new MemberImpl(member.getAddress(), member.getVersion(), true, member.getUuid(), member.getAttributes(), false, this.node.hazelcastInstance);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int getMemberListVersion() {
        return this.membershipManager.getMemberListVersion();
    }

    private MemberImpl getMasterMember() {
        MemberImpl master;
        this.lock.lock();
        try {
            Address masterAddress = this.getMasterAddress();
            if (masterAddress == null) {
                throw new IllegalStateException("Master is not known yet!");
            }
            master = this.getMember(masterAddress);
        }
        finally {
            this.lock.unlock();
        }
        return master;
    }

    public String toString() {
        return "ClusterService{address=" + this.getThisAddress() + '}';
    }
}

