/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeState;
import com.hazelcast.internal.ascii.TextCommandConstants;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.util.StringUtil;

public class HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    public static final String QUEUE_SIZE_COMMAND = "size";

    public HttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpGetCommand command) {
        String uri = command.getURI();
        if (uri.startsWith("/hazelcast/rest/maps/")) {
            this.handleMap(command, uri);
        } else if (uri.startsWith("/hazelcast/rest/queues/")) {
            this.handleQueue(command, uri);
        } else if (uri.startsWith("/hazelcast/rest/cluster")) {
            this.handleCluster(command);
        } else if (uri.equals("/hazelcast/health")) {
            this.handleHealthcheck(command);
        } else if (uri.startsWith("/hazelcast/rest/management/cluster/version")) {
            this.handleGetClusterVersion(command);
        } else {
            command.send400();
        }
        this.textCommandService.sendResponse(command);
    }

    private void handleHealthcheck(HttpGetCommand command) {
        Node node = this.textCommandService.getNode();
        NodeState nodeState = node.getState();
        ClusterServiceImpl clusterService = node.getClusterService();
        ClusterState clusterState = clusterService.getClusterState();
        int clusterSize = clusterService.getMembers().size();
        InternalPartitionService partitionService = node.getPartitionService();
        boolean memberStateSafe = partitionService.isMemberStateSafe();
        boolean clusterSafe = memberStateSafe && !partitionService.hasOnGoingMigration();
        long migrationQueueSize = partitionService.getMigrationQueueSize();
        StringBuilder res = new StringBuilder();
        res.append("Hazelcast::NodeState=").append((Object)nodeState).append("\n");
        res.append("Hazelcast::ClusterState=").append((Object)clusterState).append("\n");
        res.append("Hazelcast::ClusterSafe=").append(Boolean.toString(clusterSafe).toUpperCase()).append("\n");
        res.append("Hazelcast::MigrationQueueSize=").append(migrationQueueSize).append("\n");
        res.append("Hazelcast::ClusterSize=").append(clusterSize).append("\n");
        command.setResponse(TextCommandConstants.MIME_TEXT_PLAIN, StringUtil.stringToBytes(res.toString()));
    }

    private void handleGetClusterVersion(HttpGetCommand command) {
        String res = "{\"status\":\"${STATUS}\",\"version\":\"${VERSION}\"}";
        Node node = this.textCommandService.getNode();
        ClusterServiceImpl clusterService = node.getClusterService();
        res = res.replace("${STATUS}", "success");
        res = res.replace("${VERSION}", clusterService.getClusterVersion().toString());
        command.setResponse(HttpCommand.CONTENT_TYPE_JSON, StringUtil.stringToBytes(res));
    }

    private void handleCluster(HttpGetCommand command) {
        Node node = this.textCommandService.getNode();
        StringBuilder res = new StringBuilder(node.getClusterService().getMemberListString());
        res.append("\n");
        ConnectionManager connectionManager = node.getConnectionManager();
        res.append("ConnectionCount: ").append(connectionManager.getCurrentClientConnections());
        res.append("\n");
        res.append("AllConnectionCount: ").append(connectionManager.getAllTextConnections());
        res.append("\n");
        command.setResponse(null, StringUtil.stringToBytes(res.toString()));
    }

    private void handleQueue(HttpGetCommand command, String uri) {
        String secondStr;
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/queues/".length());
        String queueName = uri.substring("/hazelcast/rest/queues/".length(), indexEnd);
        String string = secondStr = uri.length() > indexEnd + 1 ? uri.substring(indexEnd + 1) : null;
        if (QUEUE_SIZE_COMMAND.equalsIgnoreCase(secondStr)) {
            int size = this.textCommandService.size(queueName);
            this.prepareResponse(command, Integer.toString(size));
        } else {
            int seconds = secondStr == null ? 0 : Integer.parseInt(secondStr);
            Object value = this.textCommandService.poll(queueName, seconds);
            this.prepareResponse(command, value);
        }
    }

    private void handleMap(HttpGetCommand command, String uri) {
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        Object value = this.textCommandService.get(mapName, key);
        this.prepareResponse(command, value);
    }

    @Override
    public void handleRejection(HttpGetCommand command) {
        this.handle(command);
    }

    private void prepareResponse(HttpGetCommand command, Object value) {
        if (value == null) {
            command.send204();
        } else if (value instanceof byte[]) {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, (byte[])value);
        } else if (value instanceof RestValue) {
            RestValue restValue = (RestValue)value;
            command.setResponse(restValue.getContentType(), restValue.getValue());
        } else if (value instanceof String) {
            command.setResponse(HttpCommand.CONTENT_TYPE_PLAIN_TEXT, StringUtil.stringToBytes((String)value));
        } else {
            command.setResponse(HttpCommand.CONTENT_TYPE_BINARY, this.textCommandService.toByteArray(value));
        }
    }
}

