/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ConditionAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionBeforeAwaitCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionSignalAllCodec;
import com.hazelcast.client.impl.protocol.codec.ConditionSignalCodec;
import com.hazelcast.client.proxy.ClientLockProxy;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.core.ICondition;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public class ClientConditionProxy
extends PartitionSpecificClientProxy
implements ICondition {
    private final String conditionId;
    private ClientLockReferenceIdGenerator referenceIdGenerator;

    public ClientConditionProxy(ClientLockProxy clientLockProxy, String name, ClientContext context) {
        super("hz:impl:lockService", clientLockProxy.getName(), context);
        this.conditionId = name;
    }

    @Override
    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public void awaitUninterruptibly() {
        try {
            this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long start = System.nanoTime();
        this.await(nanosTimeout, TimeUnit.NANOSECONDS);
        long end = System.nanoTime();
        return nanosTimeout - (end - start);
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        long threadId = ThreadUtil.getThreadId();
        this.beforeAwait(threadId);
        return this.doAwait(time, unit, threadId);
    }

    private void beforeAwait(long threadId) {
        ClientMessage request = ConditionBeforeAwaitCodec.encodeRequest(this.conditionId, threadId, this.name, this.referenceIdGenerator.getNextReferenceId());
        this.invokeOnPartition(request);
    }

    private boolean doAwait(long time, TimeUnit unit, long threadId) throws InterruptedException {
        long timeoutInMillis = unit.toMillis(time);
        ClientMessage request = ConditionAwaitCodec.encodeRequest(this.conditionId, threadId, timeoutInMillis, this.name, this.referenceIdGenerator.getNextReferenceId());
        ClientMessage response = this.invokeOnPartition(request);
        return ConditionAwaitCodec.decodeResponse((ClientMessage)response).response;
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        long until = deadline.getTime();
        long durationMs = until - Clock.currentTimeMillis();
        if (durationMs <= 0L) {
            return false;
        }
        return this.await(durationMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void signal() {
        ClientMessage request = ConditionSignalCodec.encodeRequest(this.conditionId, ThreadUtil.getThreadId(), this.name);
        this.invokeOnPartition(request);
    }

    @Override
    public void signalAll() {
        ClientMessage request = ConditionSignalAllCodec.encodeRequest(this.conditionId, ThreadUtil.getThreadId(), this.name);
        this.invokeOnPartition(request);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.referenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
    }
}

