/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerToKeyWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddEntryListenerWithPredicateCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapAddNearCacheEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapIsEmptyCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutAllCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.ReplicatedMapValuesCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.ListenerMessageCodec;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.Member;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.util.ResultSet;
import com.hazelcast.internal.util.ThreadLocalRandomProvider;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.monitor.LocalReplicatedMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.Preconditions;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ClientReplicatedMapProxy<K, V>
extends ClientProxy
implements ReplicatedMap<K, V> {
    private static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    private static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    private int targetPartitionId;
    private volatile NearCache<K, V> nearCache;
    private volatile String invalidationListenerId;

    public ClientReplicatedMapProxy(String serviceName, String objectName, ClientContext context) {
        super(serviceName, objectName, context);
    }

    @Override
    protected void onInitialize() {
        int partitionCount = this.getContext().getPartitionService().getPartitionCount();
        this.targetPartitionId = ThreadLocalRandomProvider.get().nextInt(partitionCount);
        this.initNearCache();
    }

    private void initNearCache() {
        NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
        if (nearCacheConfig != null) {
            this.nearCache = this.getContext().getNearCacheManager().getOrCreateNearCache(this.name, nearCacheConfig);
            if (nearCacheConfig.isInvalidateOnChange()) {
                this.registerInvalidationListener();
            }
        }
    }

    @Override
    protected void postDestroy() {
        try {
            if (this.nearCache != null) {
                this.removeNearCacheInvalidationListener();
                this.getContext().getNearCacheManager().destroyNearCache(this.name);
            }
        }
        finally {
            super.postDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, long ttl, TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        try {
            Data valueData = this.toData(value);
            Data keyData = this.toData(key);
            ClientMessage request = ReplicatedMapPutCodec.encodeRequest(this.name, keyData, valueData, timeUnit.toMillis(ttl));
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            ReplicatedMapPutCodec.ResponseParameters result = ReplicatedMapPutCodec.decodeResponse(response);
            Object t = this.toObject(result.response);
            return (V)t;
        }
        finally {
            this.invalidate(key);
        }
    }

    @Override
    public int size() {
        ClientMessage request = ReplicatedMapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapSizeCodec.ResponseParameters result = ReplicatedMapSizeCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean isEmpty() {
        ClientMessage request = ReplicatedMapIsEmptyCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapIsEmptyCodec.ResponseParameters result = ReplicatedMapIsEmptyCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = ReplicatedMapContainsKeyCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        ReplicatedMapContainsKeyCodec.ResponseParameters result = ReplicatedMapContainsKeyCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public boolean containsValue(Object value) {
        Preconditions.checkNotNull(value, NULL_KEY_IS_NOT_ALLOWED);
        Data valueData = this.toData(value);
        ClientMessage request = ReplicatedMapContainsValueCodec.encodeRequest(this.name, valueData);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapContainsValueCodec.ResponseParameters result = ReplicatedMapContainsValueCodec.decodeResponse(response);
        return result.response;
    }

    @Override
    public V get(Object userKey) {
        K key = this.validateKey(userKey);
        V cachedValue = this.getCachedValue(key);
        if (cachedValue != NearCache.NOT_CACHED) {
            return cachedValue;
        }
        try {
            Data keyData = this.toData(key);
            long reservationId = this.tryReserveForUpdate(key, keyData);
            ClientMessage request = ReplicatedMapGetCodec.encodeRequest(this.name, keyData);
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            ReplicatedMapGetCodec.ResponseParameters result = ReplicatedMapGetCodec.decodeResponse(response);
            Object value = this.toObject(result.response);
            this.tryPublishReserved(key, value, reservationId);
            return (V)value;
        }
        catch (Throwable t) {
            this.invalidate(key);
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, 0L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object userKey) {
        K key = this.validateKey(userKey);
        try {
            Data keyData = this.toData(key);
            ClientMessage request = ReplicatedMapRemoveCodec.encodeRequest(this.name, keyData);
            ClientMessage response = (ClientMessage)this.invoke(request, keyData);
            ReplicatedMapRemoveCodec.ResponseParameters result = ReplicatedMapRemoveCodec.decodeResponse(response);
            Object t = this.toObject(result.response);
            return (V)t;
        }
        finally {
            this.invalidate(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        try {
            ArrayList<Map.Entry<Data, Data>> dataEntries = new ArrayList<Map.Entry<Data, Data>>(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                Data keyData = this.toData(entry.getKey());
                Data valueData = this.toData(entry.getValue());
                dataEntries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData));
            }
            ClientMessage request = ReplicatedMapPutAllCodec.encodeRequest(this.name, dataEntries);
            this.invoke(request);
        }
        finally {
            if (this.nearCache != null) {
                for (K key : map.keySet()) {
                    this.invalidate(key);
                }
            }
        }
    }

    @Override
    public void clear() {
        try {
            ClientMessage request = ReplicatedMapClearCodec.encodeRequest(this.name);
            this.invoke(request);
        }
        finally {
            if (this.nearCache != null) {
                this.nearCache.clear();
            }
        }
    }

    @Override
    public boolean removeEntryListener(String registrationId) {
        return this.deregisterListener(registrationId);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener) {
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerCodec(), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerToKeyCodec(keyData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate) {
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerWithPredicateCodec(predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerWithPredicateCodec(final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, predicateData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data predicateData = this.toData(predicate);
        EventHandler<ClientMessage> handler = this.createHandler(listener);
        return this.registerListener(this.createEntryListenerToKeyWithPredicateCodec(keyData, predicateData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyWithPredicateCodec(final Data keyData, final Data predicateData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.encodeRequest(ClientReplicatedMapProxy.this.name, keyData, predicateData, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddEntryListenerToKeyWithPredicateCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public Set<K> keySet() {
        ClientMessage request = ReplicatedMapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapKeySetCodec.ResponseParameters result = ReplicatedMapKeySetCodec.decodeResponse(response);
        ArrayList<Map.Entry> keys = new ArrayList<Map.Entry>(result.response.size());
        for (Data dataKey : result.response) {
            keys.add(new AbstractMap.SimpleImmutableEntry(this.toObject(dataKey), null));
        }
        ResultSet resultSet = new ResultSet(keys, IterationType.KEY);
        return resultSet;
    }

    @Override
    public LocalReplicatedMapStats getReplicatedMapStats() {
        throw new UnsupportedOperationException("Replicated Map statistics are not available for client!");
    }

    @Override
    public Collection<V> values() {
        ClientMessage request = ReplicatedMapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapValuesCodec.ResponseParameters result = ReplicatedMapValuesCodec.decodeResponse(response);
        return new UnmodifiableLazyList(result.response, this.getSerializationService());
    }

    @Override
    public Collection<V> values(Comparator<V> comparator) {
        List values = (List)this.values();
        Collections.sort(values, comparator);
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = ReplicatedMapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invokeOnPartition(request, this.targetPartitionId);
        ReplicatedMapEntrySetCodec.ResponseParameters result = ReplicatedMapEntrySetCodec.decodeResponse(response);
        ArrayList<Map.Entry> entries = new ArrayList<Map.Entry>(result.response.size());
        for (Map.Entry<Data, Data> dataEntry : result.response) {
            Object key = this.toObject(dataEntry.getKey());
            Object value = this.toObject(dataEntry.getValue());
            entries.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
        ResultSet resultSet = new ResultSet(entries, IterationType.ENTRY);
        return resultSet;
    }

    private EventHandler<ClientMessage> createHandler(EntryListener<K, V> listener) {
        return new ReplicatedMapEventHandler(listener);
    }

    public String addNearCacheInvalidationListener(EventHandler handler) {
        return this.registerListener(this.createNearCacheInvalidationListenerCodec(), handler);
    }

    private void registerInvalidationListener() {
        try {
            this.invalidationListenerId = this.addNearCacheInvalidationListener(new ReplicatedMapAddNearCacheEventHandler());
        }
        catch (Exception e) {
            ILogger logger = this.getContext().getLoggingService().getLogger(ClientReplicatedMapProxy.class);
            logger.severe("-----------------\nNear Cache is not initialized!\n-----------------", e);
        }
    }

    private ListenerMessageCodec createNearCacheInvalidationListenerCodec() {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, false, localOnly);
            }

            @Override
            public String decodeAddResponse(ClientMessage clientMessage) {
                return ReplicatedMapAddNearCacheEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(String realRegistrationId) {
                return ReplicatedMapRemoveEntryListenerCodec.encodeRequest(ClientReplicatedMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return ReplicatedMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    private void removeNearCacheInvalidationListener() {
        if (this.nearCache != null && this.invalidationListenerId != null) {
            this.getContext().getListenerService().deregisterListener(this.invalidationListenerId);
        }
    }

    public String toString() {
        return "ReplicatedMap{name='" + this.name + '\'' + '}';
    }

    private K validateKey(Object key) {
        return (K)Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
    }

    private V getCachedValue(K key) {
        if (this.nearCache == null) {
            return (V)NearCache.NOT_CACHED;
        }
        V value = this.nearCache.get(key);
        if (value == null) {
            return (V)NearCache.NOT_CACHED;
        }
        if (value == NearCache.CACHED_AS_NULL) {
            return null;
        }
        return (V)this.toObject(value);
    }

    private void tryPublishReserved(K key, V value, long reservationId) {
        if (this.nearCache == null) {
            return;
        }
        if (reservationId != -1L) {
            this.nearCache.tryPublishReserved(key, value, reservationId, false);
        }
    }

    private long tryReserveForUpdate(K key, Data keyData) {
        if (this.nearCache == null) {
            return -1L;
        }
        return this.nearCache.tryReserveForUpdate(key, keyData);
    }

    private void invalidate(K key) {
        if (this.nearCache == null) {
            return;
        }
        this.nearCache.remove(key);
    }

    private class ReplicatedMapAddNearCacheEventHandler
    extends ReplicatedMapAddNearCacheEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private ReplicatedMapAddNearCacheEventHandler() {
        }

        @Override
        public void beforeListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void onListenerRegister() {
            if (ClientReplicatedMapProxy.this.nearCache != null) {
                ClientReplicatedMapProxy.this.nearCache.clear();
            }
        }

        @Override
        public void handle(Data dataKey, Data value, Data oldValue, Data mergingValue, int eventType, String uuid, int numberOfAffectedEntries) {
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: {
                    Object key = ClientReplicatedMapProxy.this.toObject(dataKey);
                    ClientReplicatedMapProxy.this.nearCache.remove(key);
                    break;
                }
                case CLEAR_ALL: {
                    ClientReplicatedMapProxy.this.nearCache.clear();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)entryEventType));
                }
            }
        }
    }

    private class ReplicatedMapEventHandler
    extends ReplicatedMapAddEntryListenerCodec.AbstractEventHandler
    implements EventHandler<ClientMessage> {
        private final EntryListener<K, V> listener;

        ReplicatedMapEventHandler(EntryListener<K, V> listener) {
            this.listener = listener;
        }

        @Override
        public void handle(Data keyData, Data valueData, Data oldValueData, Data mergingValue, int eventTypeId, String uuid, int numberOfAffectedEntries) {
            Member member = ClientReplicatedMapProxy.this.getContext().getClusterService().getMember(uuid);
            EntryEventType eventType = EntryEventType.getByType(eventTypeId);
            DataAwareEntryEvent entryEvent = new DataAwareEntryEvent(member, eventTypeId, ClientReplicatedMapProxy.this.name, keyData, valueData, oldValueData, null, ClientReplicatedMapProxy.this.getSerializationService());
            switch (eventType) {
                case ADDED: {
                    this.listener.entryAdded(entryEvent);
                    break;
                }
                case REMOVED: {
                    this.listener.entryRemoved(entryEvent);
                    break;
                }
                case UPDATED: {
                    this.listener.entryUpdated(entryEvent);
                    break;
                }
                case EVICTED: {
                    this.listener.entryEvicted(entryEvent);
                    break;
                }
                case CLEAR_ALL: {
                    MapEvent mapEvent = new MapEvent(ClientReplicatedMapProxy.this.getName(), member, eventTypeId, numberOfAffectedEntries);
                    this.listener.mapCleared(mapEvent);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type: " + (Object)((Object)eventType));
                }
            }
        }

        @Override
        public void beforeListenerRegister() {
        }

        @Override
        public void onListenerRegister() {
        }
    }
}

