/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.aws;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.config.AwsConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class AwsDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final ILogger LOGGER = Logger.getLogger(AwsDiscoveryStrategy.class);
    private final AWSClient aws;
    private final int port = this.getOrDefault(AwsProperties.PORT.getDefinition(), 5701);

    public AwsDiscoveryStrategy(Map<String, Comparable> properties) {
        super(LOGGER, properties);
        try {
            this.aws = new AWSClient(this.getAwsConfig());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidConfigurationException("AWS configuration is not valid", e);
        }
    }

    private AwsConfig getAwsConfig() throws IllegalArgumentException {
        String hostHeader;
        String region;
        AwsConfig config = new AwsConfig().setEnabled(true).setAccessKey(this.getOrNull(AwsProperties.ACCESS_KEY)).setSecretKey(this.getOrNull(AwsProperties.SECRET_KEY)).setSecurityGroupName(this.getOrNull(AwsProperties.SECURITY_GROUP_NAME)).setTagKey(this.getOrNull(AwsProperties.TAG_KEY)).setTagValue(this.getOrNull(AwsProperties.TAG_VALUE)).setIamRole(this.getOrNull(AwsProperties.IAM_ROLE));
        Integer timeout = (Integer)this.getOrNull(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition());
        if (timeout != null) {
            config.setConnectionTimeoutSeconds(timeout);
        }
        if ((region = this.getOrNull(AwsProperties.REGION)) != null) {
            config.setRegion(region);
        }
        if ((hostHeader = this.getOrNull(AwsProperties.HOST_HEADER)) != null) {
            config.setHostHeader(hostHeader);
        }
        return config;
    }

    @Override
    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Map<String, String> privatePublicIpAddressPairs = this.aws.getAddresses();
            if (privatePublicIpAddressPairs.isEmpty()) {
                this.getLogger().warning("No EC2 instances found!");
                return Collections.emptyList();
            }
            if (this.getLogger().isFinestEnabled()) {
                StringBuilder sb = new StringBuilder("Found the following EC2 instances:\n");
                for (Map.Entry<String, String> entry : privatePublicIpAddressPairs.entrySet()) {
                    sb.append("    ").append(entry.getKey()).append(" : ").append(entry.getValue()).append("\n");
                }
                this.getLogger().finest(sb.toString());
            }
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>(privatePublicIpAddressPairs.size());
            for (Map.Entry<String, String> entry : privatePublicIpAddressPairs.entrySet()) {
                nodes.add(new SimpleDiscoveryNode(new Address(entry.getKey(), this.port), new Address(entry.getValue(), this.port)));
            }
            return nodes;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private String getOrNull(AwsProperties awsProperties) {
        return (String)this.getOrNull(awsProperties.getDefinition());
    }
}

