/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.LocalMapStatsProvider;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.Query;
import com.hazelcast.map.impl.query.QueryResultSizeLimiter;
import com.hazelcast.map.impl.query.Result;
import com.hazelcast.map.impl.query.ResultProcessor;
import com.hazelcast.map.impl.query.ResultProcessorRegistry;
import com.hazelcast.monitor.impl.LocalMapStatsImpl;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.predicates.QueryOptimizer;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;

public class QueryRunner {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final QueryResultSizeLimiter queryResultSizeLimiter;
    protected final InternalSerializationService serializationService;
    protected final QueryOptimizer queryOptimizer;
    protected final OperationService operationService;
    protected final ClusterService clusterService;
    protected final LocalMapStatsProvider localMapStatsProvider;
    protected final PartitionScanExecutor partitionScanExecutor;
    protected final ResultProcessorRegistry resultProcessorRegistry;

    public QueryRunner(MapServiceContext mapServiceContext, QueryOptimizer optimizer, PartitionScanExecutor partitionScanExecutor, ResultProcessorRegistry resultProcessorRegistry) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.queryResultSizeLimiter = new QueryResultSizeLimiter(mapServiceContext, this.logger);
        this.queryOptimizer = optimizer;
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
        this.localMapStatsProvider = mapServiceContext.getLocalMapStatsProvider();
        this.partitionScanExecutor = partitionScanExecutor;
        this.resultProcessorRegistry = resultProcessorRegistry;
    }

    public Result runIndexOrPartitionScanQueryOnOwnedPartitions(Query query) throws ExecutionException, InterruptedException {
        int migrationStamp = this.getMigrationStamp();
        Collection<Integer> initialPartitions = this.mapServiceContext.getOwnedPartitions();
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        Predicate predicate = this.queryOptimizer.optimize(query.getPredicate(), mapContainer.getIndexes());
        Collection<QueryableEntry> entries = this.runUsingIndexSafely(predicate, mapContainer, migrationStamp);
        if (entries == null) {
            entries = this.runUsingPartitionScanSafely(query.getMapName(), predicate, initialPartitions, migrationStamp);
        }
        this.updateStatistics(mapContainer);
        if (entries != null) {
            return this.populateTheResult(query, entries, initialPartitions);
        }
        return this.resultProcessorRegistry.get(query.getResultType()).populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()));
    }

    private Result populateTheResult(Query query, Collection<QueryableEntry> entries, Collection<Integer> initialPartitions) {
        ResultProcessor processor = this.resultProcessorRegistry.get(query.getResultType());
        return processor.populateResult(query, this.queryResultSizeLimiter.getNodeResultLimit(initialPartitions.size()), entries, initialPartitions);
    }

    private Collection<QueryableEntry> runUsingIndexSafely(Predicate predicate, MapContainer mapContainer, int migrationStamp) {
        if (!this.validateMigrationStamp(migrationStamp)) {
            return null;
        }
        Set<QueryableEntry> entries = mapContainer.getIndexes().query(predicate);
        if (entries == null) {
            return null;
        }
        if (this.validateMigrationStamp(migrationStamp)) {
            return entries;
        }
        return null;
    }

    protected Collection<QueryableEntry> runUsingPartitionScanSafely(String name, Predicate predicate, Collection<Integer> partitions, int migrationStamp) throws InterruptedException, ExecutionException {
        if (!this.validateMigrationStamp(migrationStamp)) {
            return null;
        }
        Collection<QueryableEntry> entries = this.partitionScanExecutor.execute(name, predicate, partitions);
        if (this.validateMigrationStamp(migrationStamp)) {
            return entries;
        }
        return null;
    }

    Result runPartitionScanQueryOnGivenOwnedPartition(Query query, int partitionId) throws ExecutionException, InterruptedException {
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(query.getMapName());
        Predicate predicate = this.queryOptimizer.optimize(query.getPredicate(), mapContainer.getIndexes());
        Collection<QueryableEntry> entries = this.partitionScanExecutor.execute(query.getMapName(), predicate, Collections.singletonList(partitionId));
        return this.populateTheResult(query, entries, Collections.singletonList(partitionId));
    }

    private int getMigrationStamp() {
        return this.mapServiceContext.getService().getMigrationStamp();
    }

    private boolean validateMigrationStamp(int migrationStamp) {
        return this.mapServiceContext.getService().validateMigrationStamp(migrationStamp);
    }

    private void updateStatistics(MapContainer mapContainer) {
        if (mapContainer.getMapConfig().isStatisticsEnabled()) {
            LocalMapStatsImpl localStats = this.localMapStatsProvider.getLocalMapStatsImpl(mapContainer.getName());
            localStats.incrementOtherOperations();
        }
    }
}

