/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import java.util.Arrays;

final class PartitionReplicaVersions {
    private final int partitionId;
    private final long[] versions = new long[6];
    private boolean dirty;

    PartitionReplicaVersions(int partitionId) {
        this.partitionId = partitionId;
    }

    long[] incrementAndGet(int backupCount) {
        int i = 0;
        while (i < backupCount) {
            int n = i++;
            this.versions[n] = this.versions[n] + 1L;
        }
        return this.versions;
    }

    long[] get() {
        return this.versions;
    }

    boolean isStale(long[] newVersions, int replicaIndex) {
        int index = replicaIndex - 1;
        long currentVersion = this.versions[index];
        long newVersion = newVersions[index];
        return currentVersion > newVersion;
    }

    boolean update(long[] newVersions, int replicaIndex) {
        boolean newer;
        int index = replicaIndex - 1;
        long currentVersion = this.versions[index];
        long nextVersion = newVersions[index];
        boolean incremental = currentVersion == nextVersion - 1L;
        boolean bl = newer = currentVersion < nextVersion;
        if (newer) {
            this.setVersions(newVersions, replicaIndex);
            this.dirty = this.dirty || !incremental;
        }
        return !this.dirty;
    }

    private void setVersions(long[] newVersions, int fromReplica) {
        int fromIndex = fromReplica - 1;
        int len = newVersions.length - fromIndex;
        System.arraycopy(newVersions, fromIndex, this.versions, fromIndex, len);
    }

    void set(long[] newVersions, int fromReplica) {
        this.setVersions(newVersions, fromReplica);
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clear() {
        for (int i = 0; i < this.versions.length; ++i) {
            this.versions[i] = 0L;
        }
        this.dirty = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{partitionId=" + this.partitionId + ", versions=" + Arrays.toString(this.versions) + '}';
    }
}

