/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl;

import com.hazelcast.executor.impl.operations.CancellationOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.executor.DelegatingFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;

final class CancellableDelegatingFuture<V>
extends DelegatingFuture<V> {
    public static final int CANCEL_TRY_COUNT = 50;
    public static final int CANCEL_TRY_PAUSE_MILLIS = 250;
    private final NodeEngine nodeEngine;
    private final String uuid;
    private final int partitionId;
    private final Address target;
    private volatile boolean cancelled;

    CancellableDelegatingFuture(InternalCompletableFuture future, NodeEngine nodeEngine, String uuid, int partitionId) {
        super(future, nodeEngine.getSerializationService());
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    CancellableDelegatingFuture(InternalCompletableFuture future, NodeEngine nodeEngine, String uuid, Address target) {
        super(future, nodeEngine.getSerializationService());
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.target = target;
        this.partitionId = -1;
    }

    CancellableDelegatingFuture(InternalCompletableFuture future, V defaultValue, NodeEngine nodeEngine, String uuid, int partitionId) {
        super(future, nodeEngine.getSerializationService(), defaultValue);
        this.nodeEngine = nodeEngine;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone() || this.cancelled) {
            return false;
        }
        Future<Boolean> f = this.invokeCancelOperation(mayInterruptIfRunning);
        try {
            Boolean b = f.get();
            if (b != null && b.booleanValue()) {
                this.complete(new CancellationException());
                this.cancelled = true;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.completeWithDefault();
        }
    }

    private Future<Boolean> invokeCancelOperation(boolean mayInterruptIfRunning) {
        CancellationOperation op = new CancellationOperation(this.uuid, mayInterruptIfRunning);
        OperationService opService = this.nodeEngine.getOperationService();
        InvocationBuilder builder = this.partitionId > -1 ? opService.createInvocationBuilder("hz:impl:executorService", (Operation)op, this.partitionId) : opService.createInvocationBuilder("hz:impl:executorService", (Operation)op, this.target);
        builder.setTryCount(50).setTryPauseMillis(250L);
        return builder.invoke();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }
}

