/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.HashSet;
import java.util.Set;

public class PermissionConfig {
    private PermissionType type;
    private String name;
    private String principal;
    private Set<String> endpoints;
    private Set<String> actions;

    public PermissionConfig() {
    }

    public PermissionConfig(PermissionType type, String name, String principal) {
        this.type = type;
        this.name = name;
        this.principal = principal;
    }

    public PermissionConfig addEndpoint(String endpoint) {
        if (this.endpoints == null) {
            this.endpoints = new HashSet<String>();
        }
        this.endpoints.add(endpoint);
        return this;
    }

    public PermissionConfig addAction(String action) {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        this.actions.add(action);
        return this;
    }

    public PermissionType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public Set<String> getEndpoints() {
        if (this.endpoints == null) {
            this.endpoints = new HashSet<String>();
        }
        return this.endpoints;
    }

    public Set<String> getActions() {
        if (this.actions == null) {
            this.actions = new HashSet<String>();
        }
        return this.actions;
    }

    public PermissionConfig setType(PermissionType type) {
        this.type = type;
        return this;
    }

    public PermissionConfig setName(String name) {
        this.name = name;
        return this;
    }

    public PermissionConfig setPrincipal(String principal) {
        this.principal = principal;
        return this;
    }

    public PermissionConfig setActions(Set<String> actions) {
        this.actions = actions;
        return this;
    }

    public PermissionConfig setEndpoints(Set<String> endpoints) {
        this.endpoints = endpoints;
        return this;
    }

    public String toString() {
        return "PermissionConfig{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", principal='" + this.principal + '\'' + ", endpoints=" + this.endpoints + ", actions=" + this.actions + '}';
    }

    public static enum PermissionType {
        MAP("map-permission"),
        QUEUE("queue-permission"),
        TOPIC("topic-permission"),
        MULTIMAP("multimap-permission"),
        LIST("list-permission"),
        SET("set-permission"),
        ID_GENERATOR("id-generator-permission"),
        LOCK("lock-permission"),
        ATOMIC_LONG("atomic-long-permission"),
        COUNTDOWN_LATCH("countdown-latch-permission"),
        SEMAPHORE("semaphore-permission"),
        EXECUTOR_SERVICE("executor-service-permission"),
        TRANSACTION("transaction-permission"),
        DURABLE_EXECUTOR_SERVICE("durable-executor-service-permission"),
        CARDINALITY_ESTIMATOR("cardinality-estimator-permission"),
        SCHEDULED_EXECUTOR("scheduled-executor-permission"),
        ALL("all-permissions");

        private final String nodeName;

        private PermissionType(String nodeName) {
            this.nodeName = nodeName;
        }

        public static PermissionType getType(String nodeName) {
            for (PermissionType type : PermissionType.values()) {
                if (!nodeName.equals(type.getNodeName())) continue;
                return type;
            }
            return null;
        }

        public String getNodeName() {
            return this.nodeName;
        }
    }
}

