/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class AwsAddressTranslator
implements AddressTranslator {
    private final ILogger logger;
    private final AWSClient awsClient;
    private final boolean isInsideAws;
    private volatile Map<String, String> privateToPublic = new HashMap<String, String>();

    public AwsAddressTranslator(ClientAwsConfig awsConfig, LoggingService loggingService) {
        this(new AWSClient(awsConfig), awsConfig, loggingService);
    }

    AwsAddressTranslator(AWSClient awsClient, ClientAwsConfig awsConfig, LoggingService loggingService) {
        this.awsClient = awsClient;
        this.isInsideAws = awsConfig.isInsideAws();
        this.logger = loggingService.getLogger(AwsAddressTranslator.class);
    }

    @Override
    public Address translate(Address address) {
        if (this.isInsideAws) {
            return address;
        }
        if (address == null) {
            return null;
        }
        String publicAddress = this.privateToPublic.get(address.getHost());
        if (publicAddress != null) {
            return AwsAddressTranslator.createAddressOrNull(publicAddress, address);
        }
        if (this.privateToPublic.values().contains(address.getHost())) {
            return address;
        }
        this.refresh();
        publicAddress = this.privateToPublic.get(address.getHost());
        if (publicAddress != null) {
            return AwsAddressTranslator.createAddressOrNull(publicAddress, address);
        }
        return null;
    }

    @Override
    public void refresh() {
        try {
            this.privateToPublic = this.awsClient.getAddresses();
        }
        catch (Exception e) {
            this.logger.warning("AWS addresses failed to load: " + e.getMessage());
        }
    }

    Map<String, String> getLookupTable() {
        return this.privateToPublic;
    }

    private static Address createAddressOrNull(String hostAddress, Address portAddress) {
        try {
            return new Address(hostAddress, portAddress.getPort());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }
}

