/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCachingProvider;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.cache.impl.HazelcastClientCacheManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;

public final class HazelcastClientCachingProvider
extends AbstractHazelcastCachingProvider {
    public static HazelcastClientCachingProvider createCachingProvider(HazelcastInstance hazelcastInstance) {
        HazelcastClientCachingProvider cachingProvider = new HazelcastClientCachingProvider();
        cachingProvider.hazelcastInstance = hazelcastInstance;
        return cachingProvider;
    }

    protected HazelcastClientCacheManager createHazelcastCacheManager(URI uri, ClassLoader classLoader, Properties properties) {
        HazelcastInstance instance;
        boolean isDefaultURI = uri == null || uri.equals(this.getDefaultURI());
        try {
            instance = this.getOrCreateInstance(classLoader, properties, isDefaultURI);
            if (instance == null) {
                throw new IllegalArgumentException("Not available Hazelcast instance. Please specify your Hazelcast configuration file path via \"HazelcastCachingProvider.HAZELCAST_CONFIG_LOCATION\" property or specify Hazelcast instance name via \"HazelcastCachingProvider.HAZELCAST_INSTANCE_NAME\" property in \"properties\" parameter.");
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new HazelcastClientCacheManager(this, instance, uri, classLoader, properties);
    }

    private HazelcastInstance getOrCreateInstance(ClassLoader classLoader, Properties properties, boolean isDefaultURI) throws URISyntaxException, IOException {
        HazelcastInstance instanceItself = (HazelcastInstance)properties.get("hazelcast.instance.itself");
        if (instanceItself != null) {
            return instanceItself;
        }
        String location = properties.getProperty("hazelcast.config.location");
        if (location != null) {
            URL configURL;
            ClassLoader theClassLoader;
            URI uri = new URI(location);
            String scheme = uri.getScheme();
            if (scheme == null) {
                uri = new URI(System.getProperty(uri.getRawSchemeSpecificPart()));
            }
            ClassLoader classLoader2 = theClassLoader = classLoader == null ? this.getDefaultClassLoader() : classLoader;
            if ("classpath".equals(scheme)) {
                configURL = theClassLoader.getResource(uri.getRawSchemeSpecificPart());
            } else if ("file".equals(scheme) || "http".equals(scheme) || "https".equals(scheme)) {
                configURL = uri.toURL();
            } else {
                throw new URISyntaxException(location, "Unsupported protocol in configuration location URL");
            }
            try {
                ClientConfig config = new XmlClientConfigBuilder(configURL).build();
                config.setClassLoader(theClassLoader);
                return HazelcastClient.newHazelcastClient(config);
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        String instanceName = properties.getProperty("hazelcast.instance.name");
        if (instanceName != null) {
            return HazelcastClient.getHazelcastClientByName(instanceName);
        }
        return this.getInstanceThroughDefaultInstanceIfItIsDefault(isDefaultURI);
    }

    private HazelcastInstance getInstanceThroughDefaultInstanceIfItIsDefault(boolean isDefaultURI) {
        HazelcastInstance instance = null;
        if (isDefaultURI) {
            if (this.hazelcastInstance == null) {
                this.hazelcastInstance = instance = HazelcastClient.newHazelcastClient();
            } else {
                instance = this.hazelcastInstance;
            }
        }
        return instance;
    }

    public String toString() {
        return "HazelcastClientCachingProvider{hazelcastInstance=" + this.hazelcastInstance + '}';
    }
}

