/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationServiceSupport;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import java.io.IOException;

public class ClientNonSmartInvocationServiceImpl
extends ClientInvocationServiceSupport {
    public ClientNonSmartInvocationServiceImpl(HazelcastClientInstanceImpl client) {
        super(client);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        this.sendToOwner(invocation);
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        assert (connection != null);
        this.send(invocation, connection);
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        invocation.getClientMessage().setPartitionId(partitionId);
        this.sendToOwner(invocation);
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        this.sendToOwner(invocation);
    }

    @Override
    public ClientConnection getConnection(int partitionId) throws IOException {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address ownerConnectionAddress = clusterService.getOwnerConnectionAddress();
        if (ownerConnectionAddress == null) {
            throw new IOException("ClientNonSmartInvocationServiceImpl: Owner connection is not available.");
        }
        return (ClientConnection)this.connectionManager.getConnection(ownerConnectionAddress);
    }

    private void sendToOwner(ClientInvocation invocation) throws IOException {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address ownerConnectionAddress = clusterService.getOwnerConnectionAddress();
        if (ownerConnectionAddress == null) {
            throw new IOException("Packet is not send to owner address");
        }
        Connection conn = this.connectionManager.getConnection(ownerConnectionAddress);
        if (conn == null) {
            throw new IOException("Packet is not send to owner address :" + ownerConnectionAddress);
        }
        this.send(invocation, (ClientConnection)conn);
    }
}

