/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CardinalityEstimatorAddCodec;
import com.hazelcast.client.impl.protocol.codec.CardinalityEstimatorEstimateCodec;
import com.hazelcast.client.proxy.PartitionSpecificClientProxy;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.util.Preconditions;

public class ClientCardinalityEstimatorProxy
extends PartitionSpecificClientProxy
implements CardinalityEstimator {
    private static final ClientMessageDecoder ADD_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder ESTIMATE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CardinalityEstimatorEstimateCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    public ClientCardinalityEstimatorProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
    }

    public String toString() {
        return "CardinalityEstimator{name='" + this.name + '\'' + '}';
    }

    @Override
    public void add(Object obj) {
        this.addAsync(obj).join();
    }

    @Override
    public long estimate() {
        return (Long)this.estimateAsync().join();
    }

    public InternalCompletableFuture<Void> addAsync(Object obj) {
        Preconditions.checkNotNull(obj, "Object is null");
        Object data = this.getSerializationService().toData(obj);
        ClientMessage request = CardinalityEstimatorAddCodec.encodeRequest(this.name, data.hash64());
        return this.invokeOnPartitionAsync(request, ADD_DECODER);
    }

    public InternalCompletableFuture<Long> estimateAsync() {
        ClientMessage request = CardinalityEstimatorEstimateCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, ESTIMATE_DECODER);
    }
}

