/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.impl.BaseIndexStore;
import com.hazelcast.query.impl.ComparisonType;
import com.hazelcast.query.impl.IndexCopyBehavior;
import com.hazelcast.query.impl.IndexImpl;
import com.hazelcast.query.impl.MultiResultSet;
import com.hazelcast.query.impl.QueryableEntry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class UnsortedIndexStore
extends BaseIndexStore {
    private volatile Map<Data, QueryableEntry> recordsWithNullValue;
    private final ConcurrentMap<Comparable, Map<Data, QueryableEntry>> recordMap = new ConcurrentHashMap<Comparable, Map<Data, QueryableEntry>>(1000);
    private final BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> addFunctor;
    private final BaseIndexStore.IndexFunctor<Comparable, Data> removeFunctor;

    public UnsortedIndexStore(IndexCopyBehavior copyOn) {
        super(copyOn);
        if (copyOn == IndexCopyBehavior.COPY_ON_WRITE) {
            this.addFunctor = new CopyOnWriteAddFunctor();
            this.removeFunctor = new CopyOnWriteRemoveFunctor();
            this.recordsWithNullValue = Collections.emptyMap();
        } else {
            this.addFunctor = new AddFunctor();
            this.removeFunctor = new RemoveFunctor();
            this.recordsWithNullValue = new ConcurrentHashMap<Data, QueryableEntry>();
        }
    }

    @Override
    void newIndexInternal(Comparable newValue, QueryableEntry record) {
        this.addFunctor.invoke(newValue, record);
    }

    @Override
    void removeIndexInternal(Comparable oldValue, Data indexKey) {
        this.removeFunctor.invoke(oldValue, indexKey);
    }

    @Override
    public void clear() {
        this.takeWriteLock();
        try {
            if (this.copyOn == IndexCopyBehavior.COPY_ON_WRITE) {
                this.recordsWithNullValue = Collections.emptyMap();
            } else {
                this.recordsWithNullValue.clear();
            }
            this.recordMap.clear();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecordsBetween(Comparable from, Comparable to) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            Comparable paramFrom = from;
            Comparable paramTo = to;
            int trend = paramFrom.compareTo(paramTo);
            if (trend == 0) {
                Map records = (Map)this.recordMap.get(paramFrom);
                if (records != null) {
                    this.copyToMultiResultSet(results, records);
                }
                MultiResultSet multiResultSet = results;
                return multiResultSet;
            }
            if (trend < 0) {
                Comparable oldFrom = paramFrom;
                paramFrom = to;
                paramTo = oldFrom;
            }
            for (Map.Entry recordMapEntry : this.recordMap.entrySet()) {
                Map records;
                Comparable value = (Comparable)recordMapEntry.getKey();
                if (value.compareTo(paramFrom) > 0 || value.compareTo(paramTo) < 0 || (records = (Map)recordMapEntry.getValue()) == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getSubRecords(ComparisonType comparisonType, Comparable searchedValue) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Map.Entry recordMapEntry : this.recordMap.entrySet()) {
                Map records;
                boolean valid;
                Comparable value = (Comparable)recordMapEntry.getKey();
                int result = searchedValue.compareTo(value);
                switch (comparisonType) {
                    case LESSER: {
                        valid = result > 0;
                        break;
                    }
                    case LESSER_EQUAL: {
                        valid = result >= 0;
                        break;
                    }
                    case GREATER: {
                        valid = result < 0;
                        break;
                    }
                    case GREATER_EQUAL: {
                        valid = result <= 0;
                        break;
                    }
                    case NOT_EQUAL: {
                        valid = result != 0;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized comparisonType: " + (Object)((Object)comparisonType));
                    }
                }
                if (!valid || (records = (Map)recordMapEntry.getValue()) == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public Set<QueryableEntry> getRecords(Comparable value) {
        this.takeReadLock();
        try {
            if (value instanceof IndexImpl.NullObject) {
                Set<QueryableEntry> set = this.toSingleResultSet(this.recordsWithNullValue);
                return set;
            }
            Set<QueryableEntry> set = this.toSingleResultSet((Map)this.recordMap.get(value));
            return set;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<QueryableEntry> getRecords(Set<Comparable> values) {
        this.takeReadLock();
        try {
            MultiResultSet results = this.createMultiResultSet();
            for (Comparable value : values) {
                Map records = value instanceof IndexImpl.NullObject ? this.recordsWithNullValue : (Map)this.recordMap.get(value);
                if (records == null) continue;
                this.copyToMultiResultSet(results, records);
            }
            MultiResultSet multiResultSet = results;
            return multiResultSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String toString() {
        return "UnsortedIndexStore{recordMap=" + this.recordMap.size() + '}';
    }

    private class CopyOnWriteRemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private CopyOnWriteRemoveFunctor() {
        }

        @Override
        public void invoke(Comparable attribute, Data indexKey) {
            if (attribute instanceof IndexImpl.NullObject) {
                HashMap copy = new HashMap(UnsortedIndexStore.this.recordsWithNullValue);
                copy.remove(indexKey);
                UnsortedIndexStore.this.recordsWithNullValue = copy;
            } else {
                HashMap records = (HashMap)UnsortedIndexStore.this.recordMap.get(attribute);
                if (records != null) {
                    records = new HashMap(records);
                    records.remove(indexKey);
                    if (records.isEmpty()) {
                        UnsortedIndexStore.this.recordMap.remove(attribute);
                    } else {
                        UnsortedIndexStore.this.recordMap.put(attribute, records);
                    }
                }
            }
        }
    }

    private class RemoveFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, Data> {
        private RemoveFunctor() {
        }

        @Override
        public void invoke(Comparable attribute, Data indexKey) {
            if (attribute instanceof IndexImpl.NullObject) {
                UnsortedIndexStore.this.recordsWithNullValue.remove(indexKey);
            } else {
                Map records = (Map)UnsortedIndexStore.this.recordMap.get(attribute);
                if (records != null) {
                    records.remove(indexKey);
                    if (records.size() == 0) {
                        UnsortedIndexStore.this.recordMap.remove(attribute);
                    }
                }
            }
        }
    }

    private class CopyOnWriteAddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private CopyOnWriteAddFunctor() {
        }

        @Override
        public void invoke(Comparable attribute, QueryableEntry entry) {
            if (attribute instanceof IndexImpl.NullObject) {
                HashMap<Data, QueryableEntry> copy = new HashMap<Data, QueryableEntry>(UnsortedIndexStore.this.recordsWithNullValue);
                copy.put(entry.getKeyData(), entry);
                UnsortedIndexStore.this.recordsWithNullValue = copy;
            } else {
                Map<Data, QueryableEntry> records = (Map<Data, QueryableEntry>)UnsortedIndexStore.this.recordMap.get(attribute);
                if (records == null) {
                    records = Collections.emptyMap();
                }
                records = new HashMap(records);
                records.put(entry.getKeyData(), entry);
                UnsortedIndexStore.this.recordMap.put(attribute, records);
            }
        }
    }

    private class AddFunctor
    implements BaseIndexStore.IndexFunctor<Comparable, QueryableEntry> {
        private AddFunctor() {
        }

        @Override
        public void invoke(Comparable attribute, QueryableEntry entry) {
            if (attribute instanceof IndexImpl.NullObject) {
                UnsortedIndexStore.this.recordsWithNullValue.put(entry.getKeyData(), entry);
            } else {
                ConcurrentHashMap<Data, QueryableEntry> records = (ConcurrentHashMap<Data, QueryableEntry>)UnsortedIndexStore.this.recordMap.get(attribute);
                if (records == null) {
                    records = new ConcurrentHashMap<Data, QueryableEntry>(1, 0.75f, 1);
                    UnsortedIndexStore.this.recordMap.put(attribute, records);
                }
                records.put(entry.getKeyData(), entry);
            }
        }
    }
}

