/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.GeneratedBuildProperties;
import com.hazelcast.instance.JetBuildInfo;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.EmptyStatement;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Properties;

public final class BuildInfoProvider {
    public static final BuildInfo BUILD_INFO;
    public static final String HAZELCAST_INTERNAL_OVERRIDE_VERSION = "hazelcast.internal.override.version";
    private static final ILogger LOGGER;

    private BuildInfoProvider() {
    }

    public static BuildInfo getBuildInfo() {
        BuildInfo buildInfo = BuildInfoProvider.readBuildPropertiesClass(GeneratedBuildProperties.class, null);
        try {
            Class<?> enterpriseClass = BuildInfoProvider.class.getClassLoader().loadClass("com.hazelcast.instance.GeneratedEnterpriseBuildProperties");
            if (enterpriseClass.getClassLoader() == BuildInfoProvider.class.getClassLoader()) {
                buildInfo = BuildInfoProvider.readBuildPropertiesClass(enterpriseClass, buildInfo);
            }
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
        }
        Properties jetProperties = BuildInfoProvider.loadPropertiesFromResource("jet-runtime.properties");
        BuildInfoProvider.setJetProperties(jetProperties, buildInfo);
        return buildInfo;
    }

    static void setJetProperties(Properties properties, BuildInfo buildInfo) {
        if (properties.isEmpty()) {
            return;
        }
        String version = properties.getProperty("jet.version");
        String build = properties.getProperty("jet.build");
        String revision = properties.getProperty("jet.git.revision");
        JetBuildInfo jetBuildInfo = new JetBuildInfo(version, build, revision);
        buildInfo.setJetBuildInfo(jetBuildInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadPropertiesFromResource(String resourceName) {
        InputStream properties = BuildInfoProvider.class.getClassLoader().getResourceAsStream(resourceName);
        Properties runtimeProperties = new Properties();
        try {
            if (properties != null) {
                runtimeProperties.load(properties);
            }
        }
        catch (Exception ignored) {
            EmptyStatement.ignore(ignored);
        }
        finally {
            IOUtil.closeResource(properties);
        }
        return runtimeProperties;
    }

    private static BuildInfo readBuildPropertiesClass(Class<?> clazz, BuildInfo upstreamBuildInfo) {
        String version = BuildInfoProvider.readStaticStringField(clazz, "VERSION");
        String build = BuildInfoProvider.readStaticStringField(clazz, "BUILD");
        String revision = BuildInfoProvider.readStaticStringField(clazz, "REVISION");
        String distribution = BuildInfoProvider.readStaticStringField(clazz, "DISTRIBUTION");
        if (!revision.isEmpty() && revision.equals("${git.commit.id.abbrev}")) {
            revision = "";
        }
        int buildNumber = Integer.parseInt(build);
        boolean enterprise = !"Hazelcast".equals(distribution);
        String serialVersionString = BuildInfoProvider.readStaticStringField(clazz, "SERIALIZATION_VERSION");
        byte serialVersion = Byte.parseByte(serialVersionString);
        return BuildInfoProvider.overrideBuildInfo(version, build, revision, buildNumber, enterprise, serialVersion, upstreamBuildInfo);
    }

    private static BuildInfo overrideBuildInfo(String version, String build, String revision, int buildNumber, boolean enterprise, byte serialVersion, BuildInfo upstreamBuildInfo) {
        String overridingVersion;
        Integer hazelcastBuild = Integer.getInteger("hazelcast.build", -1);
        if (hazelcastBuild != -1) {
            build = String.valueOf(hazelcastBuild);
            buildNumber = hazelcastBuild;
        }
        if ((overridingVersion = System.getProperty(HAZELCAST_INTERNAL_OVERRIDE_VERSION)) != null) {
            LOGGER.info("Overriding hazelcast version with system property value " + overridingVersion);
            version = overridingVersion;
        }
        return new BuildInfo(version, build, revision, buildNumber, enterprise, serialVersion, upstreamBuildInfo);
    }

    private static String readStaticStringField(Class<?> clazz, String fieldName) {
        try {
            Field field = clazz.getField(fieldName);
            return (String)field.get(null);
        }
        catch (NoSuchFieldException e) {
            throw new HazelcastException(e);
        }
        catch (IllegalAccessException e) {
            throw new HazelcastException(e);
        }
    }

    static {
        LOGGER = Logger.getLogger(BuildInfoProvider.class);
        BUILD_INFO = BuildInfoProvider.getBuildInfo();
    }
}

