/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.map.impl.query.PartitionScanExecutor;
import com.hazelcast.map.impl.query.PartitionScanRunner;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.SortingUtil;
import com.hazelcast.util.executor.ManagedExecutorService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ParallelPartitionScanExecutor
implements PartitionScanExecutor {
    private final PartitionScanRunner partitionScanRunner;
    private final ManagedExecutorService executor;
    private final int timeoutInMillis;

    public ParallelPartitionScanExecutor(PartitionScanRunner partitionScanRunner, ManagedExecutorService executor, int timeoutInMillis) {
        this.partitionScanRunner = partitionScanRunner;
        this.executor = executor;
        this.timeoutInMillis = timeoutInMillis;
    }

    public List<QueryableEntry> execute(String mapName, Predicate predicate, Collection<Integer> partitions) {
        List<QueryableEntry> result = this.runUsingPartitionScanWithoutPaging(mapName, predicate, partitions);
        if (predicate instanceof PagingPredicate) {
            Map.Entry<Integer, Map.Entry> nearestAnchorEntry = PagingPredicateAccessor.getNearestAnchorEntry((PagingPredicate)predicate);
            result = SortingUtil.getSortedSubList(result, (PagingPredicate)predicate, nearestAnchorEntry);
        }
        return result;
    }

    protected List<QueryableEntry> runUsingPartitionScanWithoutPaging(String name, Predicate predicate, Collection<Integer> partitions) {
        ArrayList futures = new ArrayList(partitions.size());
        for (Integer partitionId : partitions) {
            Future<Collection<QueryableEntry>> future = this.runPartitionScanForPartition(name, predicate, partitionId);
            futures.add(future);
        }
        Collection returnedResults = ParallelPartitionScanExecutor.waitForResult(futures, this.timeoutInMillis);
        ArrayList<QueryableEntry> result = new ArrayList<QueryableEntry>();
        for (Collection returnedResult : returnedResults) {
            result.addAll(returnedResult);
        }
        return result;
    }

    protected Future<Collection<QueryableEntry>> runPartitionScanForPartition(String name, Predicate predicate, int partitionId) {
        QueryPartitionCallable task = new QueryPartitionCallable(name, predicate, partitionId);
        return this.executor.submit(task);
    }

    private static <T> Collection<Collection<T>> waitForResult(List<Future<Collection<T>>> lsFutures, int timeoutInMillis) {
        return FutureUtil.returnWithDeadline(lsFutures, timeoutInMillis, TimeUnit.MILLISECONDS, FutureUtil.RETHROW_EVERYTHING);
    }

    private final class QueryPartitionCallable
    implements Callable<Collection<QueryableEntry>> {
        protected final int partition;
        protected final String name;
        protected final Predicate predicate;

        private QueryPartitionCallable(String name, Predicate predicate, int partitionId) {
            this.name = name;
            this.predicate = predicate;
            this.partition = partitionId;
        }

        @Override
        public Collection<QueryableEntry> call() throws Exception {
            return ParallelPartitionScanExecutor.this.partitionScanRunner.run(this.name, this.predicate, this.partition);
        }
    }
}

