/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cache.impl;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheCreateConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheGetConfigCodec;
import com.hazelcast.client.impl.protocol.codec.CacheManagementConfigCodec;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.config.LegacyCacheConfig;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.FutureUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

final class ClientCacheHelper {
    private ClientCacheHelper() {
    }

    static <K, V> CacheConfig<K, V> getCacheConfig(HazelcastClientInstanceImpl client, String cacheName, String simpleCacheName) {
        ClientMessage request = CacheGetConfigCodec.encodeRequest(cacheName, simpleCacheName);
        try {
            int partitionId = client.getClientPartitionService().getPartitionId(cacheName);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, cacheName, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            ClientMessage responseMessage = (ClientMessage)future.get();
            SerializationService serializationService = client.getSerializationService();
            return ClientCacheHelper.deserializeCacheConfig(client, responseMessage, serializationService, clientInvocation);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static <K, V> CacheConfig<K, V> deserializeCacheConfig(HazelcastClientInstanceImpl client, ClientMessage responseMessage, SerializationService serializationService, ClientInvocation clientInvocation) {
        boolean compatibilityEnabled;
        Data responseData = CacheGetConfigCodec.decodeResponse((ClientMessage)responseMessage).response;
        ClientConnection sendConnection = clientInvocation.getSendConnection();
        if (null != sendConnection && -1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            LegacyCacheConfig legacyConfig = (LegacyCacheConfig)serializationService.toObject(responseData, LegacyCacheConfig.class);
            if (null == legacyConfig) {
                return null;
            }
            return legacyConfig.getConfigAndReset();
        }
        return (CacheConfig)serializationService.toObject(responseData);
    }

    static <K, V> CacheConfig<K, V> createCacheConfig(HazelcastClientInstanceImpl client, ConcurrentMap<String, CacheConfig> configs, String cacheName, CacheConfig<K, V> newCacheConfig, boolean createAlsoOnOthers, boolean syncCreate) {
        try {
            CacheConfig currentCacheConfig = (CacheConfig)configs.get(cacheName);
            String nameWithPrefix = newCacheConfig.getNameWithPrefix();
            int partitionId = client.getClientPartitionService().getPartitionId(nameWithPrefix);
            Object resolvedConfig = ClientCacheHelper.resolveCacheConfig(client, newCacheConfig, partitionId);
            Object configData = client.getSerializationService().toData(resolvedConfig);
            ClientMessage request = CacheCreateConfigCodec.encodeRequest(configData, createAlsoOnOthers);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, nameWithPrefix, partitionId);
            ClientInvocationFuture future = clientInvocation.invoke();
            if (syncCreate) {
                ClientMessage response = (ClientMessage)future.get();
                Data data = CacheCreateConfigCodec.decodeResponse((ClientMessage)response).response;
                return ClientCacheHelper.resolveCacheConfig(client, clientInvocation, data);
            }
            return currentCacheConfig;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private static <K, V> CacheConfig<K, V> resolveCacheConfig(HazelcastClientInstanceImpl client, ClientInvocation clientInvocation, Data configData) {
        boolean compatibilityEnabled;
        ClientConnection sendConnection = clientInvocation.getSendConnection();
        if (null != sendConnection && -1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            LegacyCacheConfig legacyConfig = (LegacyCacheConfig)client.getSerializationService().toObject(configData, LegacyCacheConfig.class);
            if (null == legacyConfig) {
                return null;
            }
            return legacyConfig.getConfigAndReset();
        }
        return (CacheConfig)client.getSerializationService().toObject(configData);
    }

    private static <K, V> Object resolveCacheConfig(HazelcastClientInstanceImpl client, CacheConfig<K, V> newCacheConfig, int partitionId) throws IOException {
        boolean compatibilityEnabled;
        ClientConnection sendConnection = client.getInvocationService().getConnection(partitionId);
        if (null != sendConnection && -1 == sendConnection.getConnectedServerVersion() && (compatibilityEnabled = client.getProperties().getBoolean(ClientProperty.COMPATIBILITY_3_6_SERVER_ENABLED))) {
            return new LegacyCacheConfig<K, V>(newCacheConfig);
        }
        return newCacheConfig;
    }

    static void enableStatisticManagementOnNodes(HazelcastClientInstanceImpl client, String cacheName, boolean statOrMan, boolean enabled) {
        Collection<Member> members = client.getClientClusterService().getMemberList();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Member member : members) {
            try {
                Address address = member.getAddress();
                ClientMessage request = CacheManagementConfigCodec.encodeRequest(cacheName, statOrMan, enabled, address);
                ClientInvocation clientInvocation = new ClientInvocation(client, request, cacheName, address);
                ClientInvocationFuture future = clientInvocation.invoke();
                futures.add(future);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }
}

