/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.spinning.SpinningSocketReader;
import com.hazelcast.util.ThreadUtil;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class SpinningInputThread
extends Thread {
    private static final SocketReaders SHUTDOWN = new SocketReaders();
    private static final AtomicReferenceFieldUpdater<SpinningInputThread, SocketReaders> CONNECTION_HANDLERS = AtomicReferenceFieldUpdater.newUpdater(SpinningInputThread.class, SocketReaders.class, "socketReaders");
    private volatile SocketReaders socketReaders = new SocketReaders();

    public SpinningInputThread(String hzName) {
        super(ThreadUtil.createThreadName(hzName, "in-thread"));
    }

    public void addConnection(SocketConnection connection) {
        SpinningSocketReader[] newReaders;
        SocketReaders update;
        SocketReaders current;
        SpinningSocketReader reader = (SpinningSocketReader)connection.getSocketReader();
        do {
            if ((current = this.socketReaders) == SHUTDOWN) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningSocketReader[length + 1];
            System.arraycopy(current.readers, 0, newReaders, 0, length);
            newReaders[length] = reader;
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketReaders(newReaders)));
    }

    public void removeConnection(SocketConnection connection) {
        SpinningSocketReader[] newReaders;
        SocketReaders update;
        SocketReaders current;
        SpinningSocketReader reader = (SpinningSocketReader)connection.getSocketReader();
        do {
            if ((current = this.socketReaders) == SHUTDOWN) {
                return;
            }
            int indexOf = current.indexOf(reader);
            if (indexOf == -1) {
                return;
            }
            int length = current.readers.length;
            newReaders = new SpinningSocketReader[length - 1];
            int destIndex = 0;
            for (int sourceIndex = 0; sourceIndex < length; ++sourceIndex) {
                if (sourceIndex == indexOf) continue;
                newReaders[destIndex] = current.readers[sourceIndex];
                ++destIndex;
            }
        } while (!CONNECTION_HANDLERS.compareAndSet(this, current, update = new SocketReaders(newReaders)));
    }

    public void shutdown() {
        this.socketReaders = SHUTDOWN;
        this.interrupt();
    }

    @Override
    public void run() {
        SocketReaders handlers;
        block2: while ((handlers = this.socketReaders) != SHUTDOWN) {
            SpinningSocketReader[] spinningSocketReaderArray = handlers.readers;
            int n = spinningSocketReaderArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block2;
                SpinningSocketReader reader = spinningSocketReaderArray[n2];
                try {
                    reader.read();
                }
                catch (Throwable t) {
                    reader.onFailure(t);
                }
                ++n2;
            }
            break;
        }
        return;
    }

    static class SocketReaders {
        final SpinningSocketReader[] readers;

        public SocketReaders() {
            this(new SpinningSocketReader[0]);
        }

        public SocketReaders(SpinningSocketReader[] readers) {
            this.readers = readers;
        }

        public int indexOf(SpinningSocketReader readHandler) {
            for (int k = 0; k < this.readers.length; ++k) {
                if (this.readers[k] != readHandler) continue;
                return k;
            }
            return -1;
        }
    }
}

