/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl;

import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.ringbuffer.StaleSequenceException;
import com.hazelcast.ringbuffer.impl.ArrayRingbuffer;
import com.hazelcast.ringbuffer.impl.ReadResultSetImpl;
import com.hazelcast.ringbuffer.impl.Ringbuffer;
import com.hazelcast.ringbuffer.impl.RingbufferDataSerializerHook;
import com.hazelcast.ringbuffer.impl.RingbufferExpirationPolicy;
import com.hazelcast.ringbuffer.impl.RingbufferStoreWrapper;
import com.hazelcast.ringbuffer.impl.RingbufferWaitNotifyKey;
import com.hazelcast.spi.serialization.SerializationService;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class RingbufferContainer
implements IdentifiedDataSerializable {
    private static final long TTL_DISABLED = 0L;
    private static final String EMPTY = "empty";
    private String name;
    private RingbufferWaitNotifyKey emptyRingWaitNotifyKey;
    private RingbufferExpirationPolicy expirationPolicy;
    private InMemoryFormat inMemoryFormat;
    private RingbufferConfig config;
    private RingbufferStoreWrapper store;
    private SerializationService serializationService;
    private Ringbuffer ringbuffer;

    public RingbufferContainer() {
    }

    public RingbufferContainer(String name) {
        this.name = name;
        this.emptyRingWaitNotifyKey = new RingbufferWaitNotifyKey(name, EMPTY);
    }

    public RingbufferContainer(String name, RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this(name);
        this.inMemoryFormat = config.getInMemoryFormat();
        this.ringbuffer = new ArrayRingbuffer(config.getCapacity());
        long ttlMs = TimeUnit.SECONDS.toMillis(config.getTimeToLiveSeconds());
        if (ttlMs != 0L) {
            this.expirationPolicy = new RingbufferExpirationPolicy(this.ringbuffer.getCapacity(), ttlMs);
        }
        this.init(name, config, serializationService, configClassLoader);
    }

    public void init(String name, RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this.config = config;
        this.serializationService = serializationService;
        this.initRingbufferStore(name, config, serializationService, configClassLoader);
    }

    private void initRingbufferStore(String name, RingbufferConfig config, SerializationService serializationService, ClassLoader configClassLoader) {
        this.store = RingbufferStoreWrapper.create(name, config.getRingbufferStoreConfig(), config.getInMemoryFormat(), serializationService, configClassLoader);
        if (this.store.isEnabled()) {
            try {
                long storeSequence = this.store.getLargestSequence();
                this.ringbuffer.setTailSequence(storeSequence);
                this.ringbuffer.setHeadSequence(storeSequence + 1L);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
    }

    public RingbufferStoreWrapper getStore() {
        return this.store;
    }

    public RingbufferWaitNotifyKey getRingEmptyWaitNotifyKey() {
        return this.emptyRingWaitNotifyKey;
    }

    public RingbufferConfig getConfig() {
        return this.config;
    }

    public long tailSequence() {
        return this.ringbuffer.tailSequence();
    }

    public long headSequence() {
        return this.ringbuffer.headSequence();
    }

    public void setHeadSequence(long sequence) {
        this.ringbuffer.setHeadSequence(sequence);
    }

    public long getCapacity() {
        return this.ringbuffer.getCapacity();
    }

    public long size() {
        return this.ringbuffer.size();
    }

    public boolean isEmpty() {
        return this.ringbuffer.isEmpty();
    }

    public boolean shouldWait(long sequence) {
        this.checkBlockableReadSequence(sequence);
        return sequence == this.ringbuffer.tailSequence() + 1L;
    }

    public long remainingCapacity() {
        if (this.expirationPolicy != null) {
            return this.ringbuffer.getCapacity() - this.size();
        }
        return this.ringbuffer.getCapacity();
    }

    public long add(Data item) {
        long sequence = this.addInternal(item);
        if (this.store.isEnabled()) {
            try {
                this.store.store(sequence, item);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        return sequence;
    }

    public long addAll(Data[] items) {
        long firstSequence = -1L;
        long lastSequence = -1L;
        for (int i = 0; i < items.length; ++i) {
            lastSequence = this.addInternal(items[i]);
            if (i != 0) continue;
            firstSequence = lastSequence;
        }
        if (this.store.isEnabled() && items.length != 0) {
            try {
                this.store.storeAll(firstSequence, items);
            }
            catch (Exception e) {
                throw new HazelcastException(e);
            }
        }
        return lastSequence;
    }

    public void set(long sequenceId, Data dataItem) {
        Object item = this.getRingbufferFormat(dataItem);
        this.ringbuffer.set(sequenceId, item);
        if (sequenceId > this.tailSequence()) {
            this.ringbuffer.setTailSequence(sequenceId);
            if (this.ringbuffer.size() > this.ringbuffer.getCapacity()) {
                this.ringbuffer.setHeadSequence(this.ringbuffer.tailSequence() - this.ringbuffer.getCapacity() + 1L);
            }
        }
        if (sequenceId < this.headSequence()) {
            this.ringbuffer.setHeadSequence(sequenceId);
        }
        if (this.expirationPolicy != null) {
            this.expirationPolicy.setExpirationAt(sequenceId);
        }
    }

    public Data read(long sequence) {
        this.checkReadSequence(sequence);
        Object item = this.readOrLoadItem(sequence);
        return this.serializationService.toData(item);
    }

    public long readMany(long beginSequence, ReadResultSetImpl result) {
        long seq;
        this.checkReadSequence(beginSequence);
        for (seq = beginSequence; seq <= this.ringbuffer.tailSequence(); ++seq) {
            result.addItem(this.readOrLoadItem(seq));
            if (!result.isMaxSizeReached()) continue;
            break;
        }
        return seq;
    }

    public void cleanup() {
        if (this.expirationPolicy != null) {
            this.expirationPolicy.cleanup(this.ringbuffer);
        }
    }

    public void checkBlockableReadSequence(long readSequence) {
        long tailSequence = this.ringbuffer.tailSequence();
        if (readSequence > tailSequence + 1L) {
            throw new IllegalArgumentException("sequence:" + readSequence + " is too large. The current tailSequence is:" + tailSequence);
        }
        long headSequence = this.ringbuffer.headSequence();
        if (readSequence < headSequence && !this.store.isEnabled()) {
            throw new StaleSequenceException("sequence:" + readSequence + " is too small and data store is disabled. " + "The current headSequence is:" + headSequence + " tailSequence is:" + tailSequence, headSequence);
        }
    }

    private void checkReadSequence(long sequence) {
        long tailSequence = this.ringbuffer.tailSequence();
        if (sequence > tailSequence) {
            throw new IllegalArgumentException("sequence:" + sequence + " is too large. The current tailSequence is:" + tailSequence);
        }
        long headSequence = this.ringbuffer.headSequence();
        if (sequence < headSequence && !this.store.isEnabled()) {
            throw new StaleSequenceException("sequence:" + sequence + " is too small and data store is disabled." + " The current headSequence is:" + headSequence + " tailSequence is:" + tailSequence, headSequence);
        }
    }

    private Object readOrLoadItem(long sequence) {
        Object item = sequence < this.ringbuffer.headSequence() && this.store.isEnabled() ? this.store.load(sequence) : this.ringbuffer.read(sequence);
        return item;
    }

    private long addInternal(Data dataItem) {
        Object item = this.getRingbufferFormat(dataItem);
        long tailSequence = this.ringbuffer.add(item);
        if (this.expirationPolicy != null) {
            this.expirationPolicy.setExpirationAt(tailSequence);
        }
        return tailSequence;
    }

    private Object getRingbufferFormat(Data dataItem) {
        return this.inMemoryFormat == InMemoryFormat.OBJECT ? this.serializationService.toObject(dataItem) : dataItem;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        boolean ttlEnabled = this.expirationPolicy != null;
        out.writeUTF(this.name);
        out.writeLong(this.ringbuffer.tailSequence());
        out.writeLong(this.ringbuffer.headSequence());
        out.writeInt((int)this.ringbuffer.getCapacity());
        out.writeLong(ttlEnabled ? this.expirationPolicy.getTtlMs() : 0L);
        out.writeInt(this.inMemoryFormat.ordinal());
        long now = System.currentTimeMillis();
        for (long seq = this.ringbuffer.headSequence(); seq <= this.ringbuffer.tailSequence(); ++seq) {
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                out.writeData((Data)this.ringbuffer.read(seq));
            } else {
                out.writeObject(this.ringbuffer.read(seq));
            }
            if (!ttlEnabled) continue;
            long deltaMs = this.expirationPolicy.getExpirationAt(seq) - now;
            out.writeLong(deltaMs);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        boolean ttlEnabled;
        this.name = in.readUTF();
        this.emptyRingWaitNotifyKey = new RingbufferWaitNotifyKey(this.name, EMPTY);
        long tailSequence = in.readLong();
        long headSequence = in.readLong();
        int capacity = in.readInt();
        long ttlMs = in.readLong();
        this.inMemoryFormat = InMemoryFormat.values()[in.readInt()];
        this.ringbuffer = new ArrayRingbuffer(capacity);
        this.ringbuffer.setTailSequence(tailSequence);
        this.ringbuffer.setHeadSequence(headSequence);
        boolean bl = ttlEnabled = ttlMs != 0L;
        if (ttlEnabled) {
            this.expirationPolicy = new RingbufferExpirationPolicy(capacity, ttlMs);
        }
        long now = System.currentTimeMillis();
        for (long seq = headSequence; seq <= tailSequence; ++seq) {
            if (this.inMemoryFormat == InMemoryFormat.BINARY) {
                this.ringbuffer.set(seq, in.readData());
            } else {
                this.ringbuffer.set(seq, in.readObject());
            }
            if (!ttlEnabled) continue;
            long delta = in.readLong();
            this.expirationPolicy.setExpirationAt(seq, delta + now);
        }
    }

    String getName() {
        return this.name;
    }

    Ringbuffer getRingbuffer() {
        return this.ringbuffer;
    }

    RingbufferExpirationPolicy getExpirationPolicy() {
        return this.expirationPolicy;
    }

    @Override
    public int getFactoryId() {
        return RingbufferDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 10;
    }
}

