/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.internal.networking.ReadHandler;
import com.hazelcast.internal.networking.SocketChannelWrapper;
import com.hazelcast.internal.networking.SocketReader;
import com.hazelcast.internal.networking.SocketReaderInitializer;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ascii.TextReadHandler;
import com.hazelcast.nio.tcp.ClientReadHandler;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.util.StringUtil;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketException;
import java.nio.ByteBuffer;

public class SocketReaderInitializerImpl
implements SocketReaderInitializer<TcpIpConnection> {
    private final ILogger logger;

    public SocketReaderInitializerImpl(ILogger logger) {
        this.logger = logger;
    }

    @Override
    public void init(TcpIpConnection connection, SocketReader reader) throws IOException {
        ReadHandler readHandler;
        TcpIpConnectionManager connectionManager = connection.getConnectionManager();
        IOService ioService = connectionManager.getIoService();
        ByteBuffer protocolBuffer = reader.getProtocolBuffer();
        SocketChannelWrapper socketChannel = reader.getSocketChannel();
        int readBytes = socketChannel.read(protocolBuffer);
        if (readBytes == -1) {
            throw new EOFException("Could not read protocol type!");
        }
        if (readBytes == 0 && connectionManager.isSSLEnabled()) {
            return;
        }
        if (protocolBuffer.hasRemaining()) {
            return;
        }
        String protocol = StringUtil.bytesToString(protocolBuffer.array());
        SocketWriter socketWriter = connection.getSocketWriter();
        if ("HZC".equals(protocol)) {
            this.initInputBuffer(connection, reader, ioService.getSocketReceiveBufferSize());
            connection.setType(ConnectionType.MEMBER);
            socketWriter.setProtocol("HZC");
            readHandler = ioService.createReadHandler(connection);
        } else if ("CB2".equals(protocol)) {
            this.initInputBuffer(connection, reader, ioService.getSocketClientReceiveBufferSize());
            socketWriter.setProtocol("CB2");
            readHandler = new ClientReadHandler(reader.getNormalFramesReadCounter(), connection, ioService);
        } else {
            ByteBuffer inputBuffer = this.initInputBuffer(connection, reader, ioService.getSocketReceiveBufferSize());
            socketWriter.setProtocol("TXT");
            inputBuffer.put(protocolBuffer.array());
            readHandler = new TextReadHandler(connection);
            connectionManager.incrementTextConnections();
        }
        if (readHandler == null) {
            throw new IOException("Could not initialize ReadHandler!");
        }
        reader.initReadHandler(readHandler);
    }

    private ByteBuffer initInputBuffer(TcpIpConnection connection, SocketReader reader, int sizeKb) {
        boolean directBuffer = connection.getConnectionManager().getIoService().isSocketBufferDirect();
        int sizeBytes = sizeKb * 1024;
        ByteBuffer inputBuffer = IOUtil.newByteBuffer(sizeBytes, directBuffer);
        reader.initInputBuffer(inputBuffer);
        try {
            connection.setReceiveBufferSize(sizeBytes);
        }
        catch (SocketException e) {
            this.logger.finest("Failed to adjust TCP receive buffer of " + connection + " to " + sizeBytes + " B.", e);
        }
        return inputBuffer;
    }
}

