/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.ssl;

import com.hazelcast.nio.IOUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

abstract class SSLEngineFactorySupport {
    public static final String JAVA_NET_SSL_PREFIX = "javax.net.ssl.";
    protected KeyManagerFactory kmf;
    protected TrustManagerFactory tmf;
    protected String protocol;

    SSLEngineFactorySupport() {
    }

    protected void load(Properties properties) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        KeyStore ts = KeyStore.getInstance("JKS");
        String keyStorePassword = SSLEngineFactorySupport.getProperty(properties, "keyStorePassword");
        String keyStore = SSLEngineFactorySupport.getProperty(properties, "keyStore");
        String trustStore = SSLEngineFactorySupport.getProperty(properties, "trustStore", keyStore);
        String trustStorePassword = SSLEngineFactorySupport.getProperty(properties, "trustStorePassword", keyStorePassword);
        String keyManagerAlgorithm = properties.getProperty("keyManagerAlgorithm", KeyManagerFactory.getDefaultAlgorithm());
        String trustManagerAlgorithm = properties.getProperty("trustManagerAlgorithm", TrustManagerFactory.getDefaultAlgorithm());
        this.protocol = properties.getProperty("protocol", "TLS");
        this.kmf = this.loadKeyManagerFactory(ks, keyStorePassword, keyStore, keyManagerAlgorithm);
        this.tmf = this.loadTrustManagerFactory(ts, trustStore, trustStorePassword, trustManagerAlgorithm);
    }

    private TrustManagerFactory loadTrustManagerFactory(KeyStore ts, String trustStore, String trustStorePassword, String trustManagerAlgorithm) throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException {
        if (trustStore == null) {
            return null;
        }
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(trustManagerAlgorithm);
        char[] passPhrase = trustStorePassword == null ? null : trustStorePassword.toCharArray();
        this.loadKeyStore(ts, passPhrase, trustStore);
        tmf.init(ts);
        return tmf;
    }

    private KeyManagerFactory loadKeyManagerFactory(KeyStore ks, String keyStorePassword, String keyStore, String keyManagerAlgorithm) throws NoSuchAlgorithmException, IOException, CertificateException, KeyStoreException, UnrecoverableKeyException {
        if (keyStore == null) {
            return null;
        }
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(keyManagerAlgorithm);
        char[] passPhrase = keyStorePassword == null ? null : keyStorePassword.toCharArray();
        this.loadKeyStore(ks, passPhrase, keyStore);
        kmf.init(ks, passPhrase);
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeyStore(KeyStore ks, char[] passPhrase, String keyStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException {
        FileInputStream in = new FileInputStream(keyStoreFile);
        try {
            ks.load(in, passPhrase);
        }
        finally {
            IOUtil.closeResource(in);
        }
    }

    protected static String getProperty(Properties properties, String property) {
        String value = properties.getProperty(property);
        if (value == null) {
            value = properties.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        if (value == null) {
            value = System.getProperty(JAVA_NET_SSL_PREFIX + property);
        }
        return value;
    }

    protected static String getProperty(Properties properties, String property, String defaultValue) {
        String value = SSLEngineFactorySupport.getProperty(properties, property);
        return value != null ? value : defaultValue;
    }
}

