/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.spinning;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.IOOutOfMemoryHandler;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.WriteHandler;
import com.hazelcast.internal.networking.spinning.AbstractHandler;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class SpinningSocketWriter
extends AbstractHandler
implements SocketWriter {
    private static final long TIMEOUT = 3L;
    @Probe(name="writeQueueSize")
    public final Queue<OutboundFrame> writeQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    @Probe(name="priorityWriteQueueSize")
    public final Queue<OutboundFrame> urgentWriteQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    private final SocketWriterInitializer initializer;
    private ByteBuffer outputBuffer;
    @Probe(name="bytesWritten")
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="normalFramesWritten")
    private final SwCounter normalFramesWritten = SwCounter.newSwCounter();
    @Probe(name="priorityFramesWritten")
    private final SwCounter priorityFramesWritten = SwCounter.newSwCounter();
    private volatile long lastWriteTime;
    private WriteHandler writeHandler;
    private volatile OutboundFrame currentFrame;

    public SpinningSocketWriter(SocketConnection connection, ILogger logger, IOOutOfMemoryHandler oomeHandler, SocketWriterInitializer initializer) {
        super(connection, logger, oomeHandler);
        this.initializer = initializer;
    }

    @Override
    public void write(OutboundFrame frame) {
        if (frame.isUrgent()) {
            this.urgentWriteQueue.add(frame);
        } else {
            this.writeQueue.add(frame);
        }
    }

    @Probe(name="writeQueuePendingBytes")
    public long bytesPending() {
        return this.bytesPending(this.writeQueue);
    }

    @Probe(name="priorityWriteQueuePendingBytes")
    public long priorityBytesPending() {
        return this.bytesPending(this.urgentWriteQueue);
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastWriteTime, 0L);
    }

    @Override
    public int totalFramesPending() {
        return this.urgentWriteQueue.size() + this.writeQueue.size();
    }

    private long bytesPending(Queue<OutboundFrame> writeQueue) {
        long bytesPending = 0L;
        for (OutboundFrame frame : writeQueue) {
            if (!(frame instanceof Packet)) continue;
            bytesPending += (long)((Packet)frame).packetSize();
        }
        return bytesPending;
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.lastWriteTime;
    }

    @Override
    public void initWriteHandler(WriteHandler writeHandler) {
        this.writeHandler = writeHandler;
    }

    @Override
    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    @Override
    public void setProtocol(final String protocol) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.urgentWriteQueue.add(new TaskFrame(new Runnable(){

            @Override
            public void run() {
                SpinningSocketWriter.this.logger.info("Setting protocol: " + protocol);
                if (SpinningSocketWriter.this.writeHandler == null) {
                    SpinningSocketWriter.this.initializer.init(SpinningSocketWriter.this.connection, SpinningSocketWriter.this, protocol);
                }
                latch.countDown();
            }
        }));
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest("CountDownLatch::await interrupted", e);
        }
    }

    @Override
    public void initOutputBuffer(ByteBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    private OutboundFrame poll() {
        OutboundFrame frame;
        boolean urgent;
        while (true) {
            urgent = true;
            frame = this.urgentWriteQueue.poll();
            if (frame == null) {
                urgent = false;
                frame = this.writeQueue.poll();
            }
            if (frame == null) {
                return null;
            }
            if (frame.getClass() != TaskFrame.class) break;
            TaskFrame taskFrame = (TaskFrame)frame;
            taskFrame.task.run();
        }
        if (urgent) {
            this.priorityFramesWritten.inc();
        } else {
            this.normalFramesWritten.inc();
        }
        return frame;
    }

    @Override
    public void close() {
        this.writeQueue.clear();
        this.urgentWriteQueue.clear();
        ShutdownTask shutdownTask = new ShutdownTask();
        this.write(new TaskFrame(shutdownTask));
        shutdownTask.awaitCompletion();
    }

    public void write() throws Exception {
        if (!this.connection.isAlive()) {
            return;
        }
        if (this.writeHandler == null) {
            this.logger.log(Level.WARNING, "SocketWriter is not set, creating SocketWriter with CLUSTER protocol!");
            this.initializer.init(this.connection, this, "HZC");
            return;
        }
        this.fillOutputBuffer();
        if (this.dirtyOutputBuffer()) {
            this.writeOutputBufferToSocket();
        }
    }

    private boolean dirtyOutputBuffer() {
        if (this.outputBuffer == null) {
            return false;
        }
        return this.outputBuffer.position() > 0;
    }

    private void fillOutputBuffer() throws Exception {
        while (this.outputBuffer == null || this.outputBuffer.hasRemaining()) {
            if (this.currentFrame == null) {
                this.currentFrame = this.poll();
                if (this.currentFrame == null) {
                    return;
                }
            }
            if (!this.writeHandler.onWrite(this.currentFrame, this.outputBuffer)) {
                return;
            }
            this.currentFrame = null;
        }
        return;
    }

    private void writeOutputBufferToSocket() throws Exception {
        this.outputBuffer.flip();
        int result = this.socketChannel.write(this.outputBuffer);
        if (result > 0) {
            this.lastWriteTime = System.currentTimeMillis();
            this.bytesWritten.inc(result);
        }
        if (this.outputBuffer.hasRemaining()) {
            this.outputBuffer.compact();
        } else {
            this.outputBuffer.clear();
        }
    }

    private class ShutdownTask
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);

        private ShutdownTask() {
        }

        @Override
        public void run() {
            try {
                SpinningSocketWriter.this.socketChannel.closeOutbound();
            }
            catch (IOException e) {
                SpinningSocketWriter.this.logger.finest("Error while closing outbound", e);
            }
            finally {
                this.latch.countDown();
            }
        }

        void awaitCompletion() {
            try {
                this.latch.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    private static final class TaskFrame
    implements OutboundFrame {
        private final Runnable task;

        private TaskFrame(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean isUrgent() {
            return true;
        }
    }
}

