/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.cluster.impl.SplitBrainJoinMessage;
import com.hazelcast.internal.cluster.impl.operations.AbstractJoinOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.io.IOException;

public class SplitBrainMergeValidationOperation
extends AbstractJoinOperation {
    private SplitBrainJoinMessage request;
    private SplitBrainJoinMessage response;
    private transient boolean removeCaller;

    public SplitBrainMergeValidationOperation() {
    }

    public SplitBrainMergeValidationOperation(SplitBrainJoinMessage request) {
        this.request = request;
    }

    @Override
    public void run() {
        block9: {
            ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
            NodeEngineImpl nodeEngine = (NodeEngineImpl)this.getNodeEngine();
            Node node = nodeEngine.getNode();
            if (!this.preCheck(node)) {
                return;
            }
            if (!this.masterCheck(node)) {
                return;
            }
            if (this.request != null) {
                ILogger logger = this.getLogger();
                try {
                    if (service.getClusterJoinManager().validateJoinMessage(this.request)) {
                        if (service.getClusterVersion().equals(this.request.getClusterVersion())) {
                            this.response = node.createSplitBrainJoinMessage();
                        } else {
                            logger.info("Join check from " + this.getCallerAddress() + " failed validation due to incompatible version," + "remote cluster version is " + this.request.getClusterVersion() + ", this cluster is " + service.getClusterVersion());
                        }
                    }
                    if (logger.isFineEnabled()) {
                        logger.fine("Returning " + this.response + " to " + this.getCallerAddress());
                    }
                }
                catch (Exception e) {
                    if (!logger.isFineEnabled()) break block9;
                    logger.fine("Could not validate split-brain join message! -> " + e.getMessage());
                }
            }
        }
    }

    private boolean masterCheck(Node node) {
        ILogger logger = this.getLogger();
        Address caller = this.getCallerAddress();
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        if (node.isMaster()) {
            if (service.getMember(caller) != null) {
                logger.info("Removing " + caller + ", since it thinks it's already split from this cluster " + "and looking to merge.");
                this.removeCaller = true;
            }
            return true;
        }
        service.getClusterHeartbeatManager().sendMasterConfirmation();
        logger.info("Ignoring join check from " + caller + ", because this node is not master...");
        return false;
    }

    @Override
    public void afterRun() throws Exception {
        if (this.removeCaller) {
            ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
            Address caller = this.getCallerAddress();
            service.removeAddress(caller, "Removing " + caller + ", since it thinks it's already split from this cluster " + "and looking to merge.");
        }
    }

    private boolean preCheck(Node node) {
        ILogger logger = this.getLogger();
        if (!node.joined()) {
            logger.info("Ignoring join check from " + this.getCallerAddress() + ", because this node is not joined to a cluster yet...");
            return false;
        }
        if (!node.isRunning()) {
            logger.info("Ignoring join check from " + this.getCallerAddress() + ", because this node is not active...");
            return false;
        }
        ClusterState clusterState = node.clusterService.getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            logger.info("Ignoring join check from " + this.getCallerAddress() + ", because cluster is in " + (Object)((Object)clusterState) + " state ...");
            return false;
        }
        return true;
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.request = new SplitBrainJoinMessage();
        this.request.readData(in);
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        this.request.writeData(out);
    }

    @Override
    public int getId() {
        return 13;
    }
}

