/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.impl.ClientMessageDecoder;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnAddressCodec;
import com.hazelcast.client.impl.protocol.codec.ExecutorServiceCancelOnPartitionCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.nio.Address;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public final class IExecutorDelegatingFuture<V>
extends ClientDelegatingFuture<V> {
    private final ClientContext context;
    private final String uuid;
    private final Address target;
    private final int partitionId;

    IExecutorDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, V defaultValue, ClientMessageDecoder resultDecoder, Address address) {
        super(future, context.getSerializationService(), resultDecoder, defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.partitionId = -1;
        this.target = address;
    }

    IExecutorDelegatingFuture(ClientInvocationFuture future, ClientContext context, String uuid, V defaultValue, ClientMessageDecoder resultDecoder, int partitionId) {
        super(future, context.getSerializationService(), resultDecoder, defaultValue);
        this.context = context;
        this.uuid = uuid;
        this.partitionId = partitionId;
        this.target = null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        boolean cancelSuccessful = false;
        try {
            cancelSuccessful = this.invokeCancelRequest(mayInterruptIfRunning);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        this.complete(new CancellationException());
        return cancelSuccessful;
    }

    private boolean invokeCancelRequest(boolean mayInterruptIfRunning) throws InterruptedException, ExecutionException {
        this.waitForRequestToBeSend();
        HazelcastClientInstanceImpl client = (HazelcastClientInstanceImpl)this.context.getHazelcastInstance();
        if (this.partitionId > -1) {
            ClientMessage request = ExecutorServiceCancelOnPartitionCodec.encodeRequest(this.uuid, this.partitionId, mayInterruptIfRunning);
            ClientInvocation clientInvocation = new ClientInvocation(client, request, this.partitionId);
            ClientInvocationFuture f = clientInvocation.invoke();
            return ExecutorServiceCancelOnPartitionCodec.decodeResponse((ClientMessage)((ClientMessage)f.get())).response;
        }
        ClientMessage request = ExecutorServiceCancelOnAddressCodec.encodeRequest(this.uuid, this.target, mayInterruptIfRunning);
        ClientInvocation clientInvocation = new ClientInvocation(client, request, this.target);
        ClientInvocationFuture f = clientInvocation.invoke();
        return ExecutorServiceCancelOnAddressCodec.decodeResponse((ClientMessage)((ClientMessage)f.get())).response;
    }

    private void waitForRequestToBeSend() throws InterruptedException {
        ClientInvocationFuture future;
        ClientInvocationFuture clientCallFuture = future = this.getFuture();
        clientCallFuture.getInvocation().getSendConnectionOrWait();
    }
}

