/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.accumulator;

import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfoSupplier;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DefaultAccumulatorInfoSupplier
implements AccumulatorInfoSupplier {
    private static final ConstructorFunction<String, ConcurrentMap<String, AccumulatorInfo>> INFO_CTOR = new ConstructorFunction<String, ConcurrentMap<String, AccumulatorInfo>>(){

        @Override
        public ConcurrentMap<String, AccumulatorInfo> createNew(String arg) {
            return new ConcurrentHashMap<String, AccumulatorInfo>();
        }
    };
    private final ConcurrentMap<String, ConcurrentMap<String, AccumulatorInfo>> cacheInfoPerMap = new ConcurrentHashMap<String, ConcurrentMap<String, AccumulatorInfo>>();

    @Override
    public AccumulatorInfo getAccumulatorInfoOrNull(String mapName, String cacheName) {
        ConcurrentMap cacheToInfoMap = (ConcurrentMap)this.cacheInfoPerMap.get(mapName);
        return (AccumulatorInfo)cacheToInfoMap.get(cacheName);
    }

    @Override
    public void putIfAbsent(String mapName, String cacheName, AccumulatorInfo info) {
        ConcurrentMap<String, AccumulatorInfo> cacheToInfoMap = ConcurrencyUtil.getOrPutIfAbsent(this.cacheInfoPerMap, mapName, INFO_CTOR);
        cacheToInfoMap.putIfAbsent(cacheName, info);
    }

    @Override
    public void remove(String mapName, String cacheName) {
        ConcurrentMap cacheToInfoMap = (ConcurrentMap)this.cacheInfoPerMap.get(mapName);
        if (cacheToInfoMap == null) {
            return;
        }
        cacheToInfoMap.remove(cacheName);
    }
}

