/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.ReplicaErrorLogger;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.impl.PartitionStateManager;
import com.hazelcast.internal.partition.operation.AbstractPartitionOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.PartitionAwareOperation;
import com.hazelcast.spi.UrgentSystemOperation;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.spi.impl.AllowedDuringPassiveState;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;

@SuppressFBWarnings(value={"EI_EXPOSE_REP"})
public class ReplicaSyncResponse
extends AbstractPartitionOperation
implements PartitionAwareOperation,
BackupOperation,
UrgentSystemOperation,
AllowedDuringPassiveState {
    private List<Operation> tasks;
    private long[] replicaVersions;

    public ReplicaSyncResponse() {
    }

    public ReplicaSyncResponse(List<Operation> data, long[] replicaVersions) {
        this.tasks = data;
        this.replicaVersions = replicaVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        NodeEngine nodeEngine = this.getNodeEngine();
        InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionStateManager partitionStateManager = partitionService.getPartitionStateManager();
        InternalPartitionImpl partition = partitionStateManager.getPartitionImpl(partitionId);
        Address thisAddress = nodeEngine.getThisAddress();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        try {
            if (replicaIndex == currentReplicaIndex) {
                this.executeTasks();
            } else {
                this.nodeNotOwnsBackup(partition);
            }
            if (this.tasks != null) {
                this.tasks.clear();
            }
        }
        finally {
            this.postProcessReplicaSync(partitionService, currentReplicaIndex);
        }
    }

    private void postProcessReplicaSync(InternalPartitionServiceImpl partitionService, int currentReplicaIndex) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        PartitionReplicaManager replicaManager = partitionService.getReplicaManager();
        if (replicaIndex == currentReplicaIndex) {
            replicaManager.finalizeReplicaSync(partitionId, replicaIndex, this.replicaVersions);
        } else {
            replicaManager.clearReplicaSyncRequest(partitionId, replicaIndex);
            if (currentReplicaIndex < 0) {
                replicaManager.clearPartitionReplicaVersions(partitionId);
            } else if (currentReplicaIndex > 0) {
                replicaManager.triggerPartitionReplicaSync(partitionId, currentReplicaIndex, 0L);
            }
        }
    }

    private void nodeNotOwnsBackup(InternalPartitionImpl partition) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        Address thisAddress = this.getNodeEngine().getThisAddress();
        int currentReplicaIndex = partition.getReplicaIndex(thisAddress);
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("This node is not backup replica of partitionId=" + partitionId + ", replicaIndex=" + replicaIndex + " anymore. current replicaIndex=" + currentReplicaIndex);
        }
        if (this.tasks != null) {
            WrongTargetException throwable = new WrongTargetException(thisAddress, partition.getReplicaAddress(replicaIndex), partitionId, replicaIndex, this.getClass().getName());
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, throwable);
            }
        }
    }

    private void executeTasks() {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        if (this.tasks != null && !this.tasks.isEmpty()) {
            this.logApplyReplicaSync(partitionId, replicaIndex);
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                try {
                    op.beforeRun();
                    op.run();
                    op.afterRun();
                }
                catch (Throwable e) {
                    this.onOperationFailure(op, e);
                    this.logException(op, e);
                }
            }
        } else {
            this.logEmptyTaskList(partitionId, replicaIndex);
        }
    }

    private void prepareOperation(Operation op) {
        int partitionId = this.getPartitionId();
        int replicaIndex = this.getReplicaIndex();
        NodeEngine nodeEngine = this.getNodeEngine();
        ILogger opLogger = nodeEngine.getLogger(op.getClass());
        OperationResponseHandler responseHandler = OperationResponseHandlerFactory.createErrorLoggingResponseHandler(opLogger);
        op.setNodeEngine(nodeEngine).setPartitionId(partitionId).setReplicaIndex(replicaIndex).setOperationResponseHandler(responseHandler);
    }

    private void logEmptyTaskList(int partitionId, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("No data available for replica sync, partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
        }
    }

    private void logException(Operation op, Throwable e) {
        Level level;
        ILogger logger = this.getLogger();
        NodeEngine nodeEngine = this.getNodeEngine();
        Level level2 = level = nodeEngine.isRunning() ? Level.WARNING : Level.FINEST;
        if (logger.isLoggable(level)) {
            logger.log(level, "While executing " + op, e);
        }
    }

    private void logApplyReplicaSync(int partitionId, int replicaIndex) {
        ILogger logger = this.getLogger();
        if (logger.isFinestEnabled()) {
            logger.finest("Applying replica sync for partitionId=" + partitionId + ", replicaIndex=" + replicaIndex);
        }
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    public boolean validatesTarget() {
        return false;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.tasks != null) {
            for (Operation op : this.tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    public void logError(Throwable e) {
        ReplicaErrorLogger.log(e, this.getLogger());
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeLongArray(this.replicaVersions);
        int size = this.tasks != null ? this.tasks.size() : 0;
        out.writeInt(size);
        if (size > 0) {
            for (Operation task : this.tasks) {
                out.writeObject(task);
            }
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.replicaVersions = in.readLongArray();
        int size = in.readInt();
        if (size > 0) {
            this.tasks = new ArrayList<Operation>(size);
            for (int i = 0; i < size; ++i) {
                Operation op = (Operation)in.readObject();
                this.tasks.add(op);
            }
        }
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", replicaVersions=").append(Arrays.toString(this.replicaVersions));
    }

    @Override
    public int getId() {
        return 12;
    }
}

