/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.adapter;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.SimpleCompletedFuture;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.transaction.TransactionContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class TransactionalMapDataStructureAdapter<K, V>
implements DataStructureAdapter<K, V> {
    private final HazelcastInstance hazelcastInstance;
    private final String name;
    private TransactionContext transactionContext;
    private TransactionalMap<K, V> transactionalMap;

    public TransactionalMapDataStructureAdapter(HazelcastInstance hazelcastInstance, String name) {
        this.hazelcastInstance = hazelcastInstance;
        this.name = name;
    }

    @Override
    public void clear() {
        this.begin();
        for (K key : this.transactionalMap.keySet()) {
            this.transactionalMap.remove(key);
        }
        this.commit();
    }

    @Override
    public void set(K key, V value) {
        this.begin();
        this.transactionalMap.put(key, value);
        this.commit();
    }

    @Override
    public V put(K key, V value) {
        this.begin();
        V oldValue = this.transactionalMap.put(key, value);
        this.commit();
        return oldValue;
    }

    @Override
    public V get(K key) {
        this.begin();
        V value = this.transactionalMap.get(key);
        this.commit();
        return value;
    }

    @Override
    public ICompletableFuture<V> getAsync(K key) {
        this.begin();
        V value = this.transactionalMap.get(key);
        this.commit();
        return new SimpleCompletedFuture<V>(value);
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.begin();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.transactionalMap.put(entry.getKey(), entry.getValue());
        }
        this.commit();
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        this.begin();
        HashMap<K, V> result = new HashMap<K, V>(keys.size());
        for (K key : keys) {
            result.put(key, this.transactionalMap.get(key));
        }
        this.commit();
        return result;
    }

    @Override
    public void remove(K key) {
        this.begin();
        this.transactionalMap.remove(key);
        this.commit();
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return null;
    }

    @Override
    public boolean containsKey(K key) {
        this.begin();
        boolean result = this.transactionalMap.containsKey(key);
        this.commit();
        return result;
    }

    private void begin() {
        this.transactionContext = this.hazelcastInstance.newTransactionContext();
        this.transactionContext.beginTransaction();
        this.transactionalMap = this.transactionContext.getMap(this.name);
    }

    private void commit() {
        this.transactionContext.commitTransaction();
        this.transactionContext = null;
        this.transactionalMap = null;
    }
}

