/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.spi.ClientClusterService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.Member;
import com.hazelcast.core.Partition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.partition.NoDataMemberInClusterException;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.HashUtil;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientPartitionServiceImpl
implements ClientPartitionService {
    private static final long PERIOD = 10L;
    private static final long INITIAL_DELAY = 10L;
    private static final int PARTITION_WAIT_TIME = 1000;
    private final ILogger logger;
    private final ExecutionCallback<ClientMessage> refreshTaskCallback = new RefreshTaskCallback();
    private final HazelcastClientInstanceImpl client;
    private final ConcurrentHashMap<Integer, Address> partitions = new ConcurrentHashMap(271, 0.75f, 1);
    private final AtomicBoolean updating = new AtomicBoolean(false);
    private volatile int partitionCount;

    public ClientPartitionServiceImpl(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.logger = client.getLoggingService().getLogger(ClientPartitionService.class);
    }

    public void start() {
        ClientExecutionServiceImpl clientExecutionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        ExecutorService internalExecutor = clientExecutionService.getInternalExecutor();
        clientExecutionService.scheduleWithRepetition(new RefreshTask(internalExecutor), 10L, 10L, TimeUnit.SECONDS);
    }

    public void refreshPartitions() {
        ClientExecutionServiceImpl executionService = (ClientExecutionServiceImpl)this.client.getClientExecutionService();
        try {
            ExecutorService internalExecutor = executionService.getInternalExecutor();
            executionService.submitInternal(new RefreshTask(internalExecutor));
        }
        catch (RejectedExecutionException ignored) {
            EmptyStatement.ignore(ignored);
        }
    }

    private void getPartitionsBlocking() {
        while (!this.getPartitions() && this.client.getConnectionManager().isAlive()) {
            if (this.isClusterFormedByOnlyLiteMembers()) {
                throw new NoDataMemberInClusterException("Partitions can't be assigned since all nodes in the cluster are lite members");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isClusterFormedByOnlyLiteMembers() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        return clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR).isEmpty();
    }

    private Connection getOwnerConnection() {
        ClientClusterService clusterService = this.client.getClientClusterService();
        Address ownerAddress = clusterService.getOwnerConnectionAddress();
        if (ownerAddress == null) {
            return null;
        }
        Connection connection = this.client.getConnectionManager().getConnection(ownerAddress);
        if (connection == null) {
            return null;
        }
        return connection;
    }

    private boolean getPartitions() {
        Connection connection = this.getOwnerConnection();
        if (connection == null) {
            return false;
        }
        try {
            ClientInvocationFuture future = this.getPartitionsFrom(connection);
            ClientMessage responseMessage = (ClientMessage)future.get();
            ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
            if (response == null) {
                return false;
            }
            return this.processPartitionResponse(response);
        }
        catch (Exception e) {
            if (this.client.getLifecycleService().isRunning()) {
                this.logger.warning("Error while fetching cluster partition table!", e);
            }
            return false;
        }
    }

    private ClientInvocationFuture getPartitionsFrom(Connection connection) {
        ClientMessage requestMessage = ClientGetPartitionsCodec.encodeRequest();
        return new ClientInvocation(this.client, requestMessage, connection).invokeUrgent();
    }

    private boolean processPartitionResponse(ClientGetPartitionsCodec.ResponseParameters response) {
        this.logger.finest("Processing partition response.");
        List<Map.Entry<Address, List<Integer>>> partitions = response.partitions;
        for (Map.Entry<Address, List<Integer>> entry : partitions) {
            Address address = entry.getKey();
            for (Integer partition : entry.getValue()) {
                this.partitions.put(partition, address);
            }
        }
        this.partitionCount = this.partitions.size();
        return partitions.size() > 0;
    }

    public void stop() {
        this.partitions.clear();
    }

    @Override
    public Address getPartitionOwner(int partitionId) {
        Address address = this.partitions.get(partitionId);
        if (address == null) {
            this.getPartitionsBlocking();
        }
        return this.partitions.get(partitionId);
    }

    @Override
    public int getPartitionId(Data key) {
        int pc = this.getPartitionCount();
        if (pc <= 0) {
            return 0;
        }
        int hash = key.getPartitionHash();
        return HashUtil.hashToIndex(hash, pc);
    }

    @Override
    public int getPartitionId(Object key) {
        Object data = this.client.getSerializationService().toData(key);
        return this.getPartitionId((Data)data);
    }

    @Override
    public int getPartitionCount() {
        if (this.partitionCount == 0) {
            this.getPartitionsBlocking();
        }
        return this.partitionCount;
    }

    @Override
    public Partition getPartition(int partitionId) {
        return new PartitionImpl(partitionId);
    }

    private class RefreshTaskCallback
    implements ExecutionCallback<ClientMessage> {
        private RefreshTaskCallback() {
        }

        @Override
        public void onResponse(ClientMessage responseMessage) {
            try {
                if (responseMessage == null) {
                    return;
                }
                ClientGetPartitionsCodec.ResponseParameters response = ClientGetPartitionsCodec.decodeResponse(responseMessage);
                ClientPartitionServiceImpl.this.processPartitionResponse(response);
            }
            finally {
                ClientPartitionServiceImpl.this.updating.set(false);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) {
                ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", t);
            }
            ClientPartitionServiceImpl.this.updating.set(false);
        }
    }

    private class RefreshTask
    implements Runnable {
        private ExecutorService executionService;

        public RefreshTask(ExecutorService service) {
            this.executionService = service;
        }

        @Override
        public void run() {
            if (!ClientPartitionServiceImpl.this.updating.compareAndSet(false, true)) {
                return;
            }
            Connection connection = ClientPartitionServiceImpl.this.getOwnerConnection();
            if (connection == null) {
                ClientPartitionServiceImpl.this.updating.set(false);
                return;
            }
            try {
                ClientInvocationFuture clientInvocationFuture = ClientPartitionServiceImpl.this.getPartitionsFrom(connection);
                clientInvocationFuture.andThen(ClientPartitionServiceImpl.this.refreshTaskCallback, this.executionService);
            }
            catch (Exception e) {
                if (ClientPartitionServiceImpl.this.client.getLifecycleService().isRunning()) {
                    ClientPartitionServiceImpl.this.logger.warning("Error while fetching cluster partition table!", e);
                }
                ClientPartitionServiceImpl.this.updating.set(false);
            }
        }
    }

    private final class PartitionImpl
    implements Partition {
        private final int partitionId;

        private PartitionImpl(int partitionId) {
            this.partitionId = partitionId;
        }

        @Override
        public int getPartitionId() {
            return this.partitionId;
        }

        @Override
        public Member getOwner() {
            Address owner = ClientPartitionServiceImpl.this.getPartitionOwner(this.partitionId);
            if (owner != null) {
                return ClientPartitionServiceImpl.this.client.getClientClusterService().getMember(owner);
            }
            return null;
        }

        public String toString() {
            return "PartitionImpl{partitionId=" + this.partitionId + '}';
        }
    }
}

