/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClientFactory;
import com.hazelcast.client.HazelcastClientManager;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OutOfMemoryHandler;
import java.util.Collection;

public final class HazelcastClient {
    private static final HazelcastClientFactory HAZELCAST_CLIENT_FACTORY = new HazelcastClientFactory(){

        public HazelcastClientInstanceImpl createHazelcastInstanceClient(ClientConfig config, ClientConnectionManagerFactory factory) {
            return new HazelcastClientInstanceImpl(config, factory, null);
        }

        public HazelcastClientProxy createProxy(HazelcastClientInstanceImpl client) {
            return new HazelcastClientProxy(client);
        }
    };

    private HazelcastClient() {
    }

    public static HazelcastInstance newHazelcastClient() {
        return HazelcastClientManager.newHazelcastClient(HAZELCAST_CLIENT_FACTORY);
    }

    public static HazelcastInstance newHazelcastClient(ClientConfig config) {
        return HazelcastClientManager.newHazelcastClient(config, HAZELCAST_CLIENT_FACTORY);
    }

    public static HazelcastInstance getHazelcastClientByName(String instanceName) {
        return HazelcastClientManager.getHazelcastClientByName(instanceName);
    }

    public static Collection<HazelcastInstance> getAllHazelcastClients() {
        return HazelcastClientManager.getAllHazelcastClients();
    }

    public static void shutdownAll() {
        HazelcastClientManager.shutdownAll();
    }

    public static void shutdown(HazelcastInstance instance) {
        HazelcastClientManager.shutdown(instance);
    }

    public static void shutdown(String instanceName) {
        HazelcastClientManager.shutdown(instanceName);
    }

    public static void setOutOfMemoryHandler(OutOfMemoryHandler outOfMemoryHandler) {
        HazelcastClientManager.setOutOfMemoryHandler(outOfMemoryHandler);
    }
}

