/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientReadHandler;
import com.hazelcast.client.connection.nio.ClientWriteHandler;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.util.Clock;
import com.hazelcast.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class ClientConnection
implements Connection {
    @Probe
    protected final int connectionId;
    private final AtomicBoolean live = new AtomicBoolean(true);
    private final ILogger logger;
    private final AtomicInteger pendingPacketCount = new AtomicInteger(0);
    private final ClientWriteHandler writeHandler;
    private final ClientReadHandler readHandler;
    private final SocketChannelWrapper socketChannelWrapper;
    private final ClientConnectionManager connectionManager;
    private final LifecycleService lifecycleService;
    private final HazelcastClientInstanceImpl client;
    private volatile Address remoteEndpoint;
    private volatile boolean isHeartBeating = true;
    private volatile long lastHeartbeatRequestedMillis;
    private volatile long lastHeartbeatReceivedMillis;
    private boolean isAuthenticatedAsOwner;
    @Probe(level=ProbeLevel.DEBUG)
    private volatile long closedTime;
    private volatile Throwable closeCause;
    private volatile String closeReason;
    private int connectedServerVersion = -1;
    private String connectedServerVersionString;
    private List<Member> clientUnregisteredMembers;

    public ClientConnection(HazelcastClientInstanceImpl client, NonBlockingIOThread in, NonBlockingIOThread out, int connectionId, SocketChannelWrapper socketChannelWrapper) throws IOException {
        Socket socket = socketChannelWrapper.socket();
        this.client = client;
        this.connectionManager = client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.socketChannelWrapper = socketChannelWrapper;
        this.connectionId = connectionId;
        LoggingService clientLoggingService = client.getLoggingService();
        this.logger = clientLoggingService.getLogger(ClientConnection.class);
        boolean directBuffer = client.getProperties().getBoolean(GroupProperty.SOCKET_CLIENT_BUFFER_DIRECT);
        this.readHandler = new ClientReadHandler(this, in, socket.getReceiveBufferSize(), directBuffer, clientLoggingService);
        this.writeHandler = new ClientWriteHandler(this, out, socket.getSendBufferSize(), directBuffer, clientLoggingService);
        MetricsRegistryImpl metricsRegistry = client.getMetricsRegistry();
        String connectionName = "tcp.connection[" + socket.getLocalSocketAddress() + " -> " + socket.getRemoteSocketAddress() + "]";
        metricsRegistry.scanAndRegister(this, connectionName);
        metricsRegistry.scanAndRegister(this.readHandler, connectionName + ".in");
        metricsRegistry.scanAndRegister(this.writeHandler, connectionName + ".out");
    }

    public ClientConnection(HazelcastClientInstanceImpl client, int connectionId) throws IOException {
        this.client = client;
        this.connectionManager = client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.connectionId = connectionId;
        this.writeHandler = null;
        this.readHandler = null;
        this.socketChannelWrapper = null;
        this.logger = client.getLoggingService().getLogger(ClientConnection.class);
    }

    public void incrementPendingPacketCount() {
        this.pendingPacketCount.incrementAndGet();
    }

    public void decrementPendingPacketCount() {
        this.pendingPacketCount.decrementAndGet();
    }

    public int getPendingPacketCount() {
        return this.pendingPacketCount.get();
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (!this.live.get()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, dropping frame -> " + frame);
            }
            return false;
        }
        this.writeHandler.enqueue(frame);
        return true;
    }

    public void init() throws IOException {
        ByteBuffer buffer = ByteBuffer.allocate(3);
        buffer.put(StringUtil.stringToBytes("CB2"));
        buffer.flip();
        this.socketChannelWrapper.write(buffer);
    }

    @Override
    public Address getEndPoint() {
        return this.remoteEndpoint;
    }

    @Override
    public boolean isAlive() {
        return this.live.get();
    }

    @Override
    public long lastReadTimeMillis() {
        return this.readHandler.getLastHandle();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.writeHandler.getLastHandle();
    }

    @Override
    public void setType(ConnectionType type) {
    }

    @Override
    public ConnectionType getType() {
        return ConnectionType.JAVA_CLIENT;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannelWrapper.socket().getInetAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getRemoteSocketAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannelWrapper.socket().getPort();
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannelWrapper;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientReadHandler getReadHandler() {
        return this.readHandler;
    }

    public void setRemoteEndpoint(Address remoteEndpoint) {
        this.remoteEndpoint = remoteEndpoint;
    }

    public Address getRemoteEndpoint() {
        return this.remoteEndpoint;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return (InetSocketAddress)this.socketChannelWrapper.socket().getLocalSocketAddress();
    }

    @Override
    public void close(String reason, Throwable cause) {
        if (!this.live.compareAndSet(true, false)) {
            return;
        }
        this.closeCause = cause;
        this.closeReason = reason;
        this.closedTime = System.currentTimeMillis();
        String message = this + " lost. Reason: ";
        message = cause != null ? message + cause.getClass().getName() + '[' + cause.getMessage() + ']' : message + "Socket explicitly closed";
        try {
            this.innerClose();
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        if (this.lifecycleService.isRunning()) {
            this.logger.warning(message);
        } else {
            this.logger.finest(message);
        }
    }

    protected void innerClose() throws IOException {
        if (this.socketChannelWrapper.isOpen()) {
            this.socketChannelWrapper.close();
        }
        this.readHandler.shutdown();
        this.writeHandler.shutdown();
        MetricsRegistryImpl metricsRegistry = this.client.getMetricsRegistry();
        metricsRegistry.deregister(this);
        metricsRegistry.deregister(this.writeHandler);
        metricsRegistry.deregister(this.readHandler);
    }

    @Override
    public Throwable getCloseCause() {
        return this.closeCause;
    }

    @Override
    public String getCloseReason() {
        return this.closeReason;
    }

    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="incremented in single thread")
    void onHeartbeatFailed() {
        this.isHeartBeating = false;
    }

    void onHeartbeatResumed() {
        this.isHeartBeating = true;
    }

    void onHeartbeatReceived() {
        this.lastHeartbeatReceivedMillis = Clock.currentTimeMillis();
    }

    void onHeartbeatRequested() {
        this.lastHeartbeatRequestedMillis = Clock.currentTimeMillis();
    }

    public long getLastHeartbeatRequestedMillis() {
        return this.lastHeartbeatRequestedMillis;
    }

    public long getLastHeartbeatReceivedMillis() {
        return this.lastHeartbeatReceivedMillis;
    }

    public boolean isHeartBeating() {
        return this.live.get() && this.isHeartBeating;
    }

    public boolean isAuthenticatedAsOwner() {
        return this.isAuthenticatedAsOwner;
    }

    public void setIsAuthenticatedAsOwner() {
        this.isAuthenticatedAsOwner = true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClientConnection)) {
            return false;
        }
        ClientConnection that = (ClientConnection)o;
        return this.connectionId == that.connectionId;
    }

    public int hashCode() {
        return this.connectionId;
    }

    public String toString() {
        return "ClientConnection{live=" + this.live + ", connectionId=" + this.connectionId + ", socketChannel=" + this.socketChannelWrapper + ", remoteEndpoint=" + this.remoteEndpoint + ", lastReadTime=" + StringUtil.timeToStringFriendly(this.lastReadTimeMillis()) + ", lastWriteTime=" + StringUtil.timeToStringFriendly(this.lastWriteTimeMillis()) + ", closedTime=" + StringUtil.timeToStringFriendly(this.closedTime) + ", lastHeartbeatRequested=" + StringUtil.timeToStringFriendly(this.lastHeartbeatRequestedMillis) + ", lastHeartbeatReceived=" + StringUtil.timeToStringFriendly(this.lastHeartbeatReceivedMillis) + ", connected server version=" + this.connectedServerVersionString + '}';
    }

    public long getClosedTime() {
        return this.closedTime;
    }

    public void setConnectedServerVersion(String connectedServerVersion) {
        this.connectedServerVersionString = connectedServerVersion;
        this.connectedServerVersion = BuildInfo.calculateVersion(connectedServerVersion);
    }

    public int getConnectedServerVersion() {
        return this.connectedServerVersion;
    }

    public String getConnectedServerVersionString() {
        return this.connectedServerVersionString;
    }

    public List<Member> getClientUnregisteredMembers() {
        return this.clientUnregisteredMembers;
    }

    public void setClientUnregisteredMembers(List<Member> clientUnregisteredMembers) {
        this.clientUnregisteredMembers = clientUnregisteredMembers;
    }
}

