/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp.spinning;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.tcp.TcpIpConnection;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import java.io.EOFException;

public abstract class AbstractHandler {
    protected final TcpIpConnectionManager connectionManager;
    protected final TcpIpConnection connection;
    protected final ILogger logger;
    protected final IOService ioService;

    public AbstractHandler(TcpIpConnection connection, ILogger logger) {
        this.connection = connection;
        this.connectionManager = connection.getConnectionManager();
        this.logger = logger;
        this.ioService = this.connectionManager.getIoService();
    }

    public void onFailure(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            this.connectionManager.getIoService().onOutOfMemory((OutOfMemoryError)e);
        }
        if (e instanceof EOFException) {
            this.connection.close("Connection closed by the other side", e);
        } else {
            this.connection.close("Exception in " + this.getClass().getSimpleName(), e);
        }
    }
}

