/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.impl;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.partition.InternalPartition;
import com.hazelcast.internal.partition.PartitionListener;
import com.hazelcast.internal.partition.PartitionStateGenerator;
import com.hazelcast.internal.partition.impl.InternalPartitionImpl;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.NopPartitionListener;
import com.hazelcast.internal.partition.impl.PartitionStateGeneratorImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.partition.membergroup.MemberGroup;
import com.hazelcast.partition.membergroup.MemberGroupFactory;
import com.hazelcast.partition.membergroup.MemberGroupFactoryFactory;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class PartitionStateManager {
    private final Node node;
    private final ILogger logger;
    private final int partitionCount;
    private final InternalPartitionImpl[] partitions;
    @Probe
    private final AtomicInteger stateVersion = new AtomicInteger();
    private final PartitionStateGenerator partitionStateGenerator;
    private final MemberGroupFactory memberGroupFactory;
    private volatile boolean initialized;
    @Probe
    private volatile int memberGroupsSize;

    public PartitionStateManager(Node node, InternalPartitionServiceImpl partitionService, PartitionListener listener) {
        this.node = node;
        this.logger = node.getLogger(this.getClass());
        this.partitionCount = partitionService.getPartitionCount();
        this.partitions = new InternalPartitionImpl[this.partitionCount];
        Address thisAddress = node.getThisAddress();
        for (int i = 0; i < this.partitionCount; ++i) {
            this.partitions[i] = new InternalPartitionImpl(i, listener, thisAddress);
        }
        this.memberGroupFactory = MemberGroupFactoryFactory.newMemberGroupFactory(node.getConfig().getPartitionGroupConfig(), node.getDiscoveryService());
        this.partitionStateGenerator = new PartitionStateGeneratorImpl();
    }

    @Probe
    private int localPartitionCount() {
        int count = 0;
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isLocal()) continue;
            ++count;
        }
        return count;
    }

    private Collection<MemberGroup> createMemberGroups(final Set<Address> excludedAddresses) {
        MemberSelector exclude = new MemberSelector(){

            @Override
            public boolean select(Member member) {
                return !excludedAddresses.contains(member.getAddress());
            }
        };
        MemberSelector selector = MemberSelectors.and(MemberSelectors.DATA_MEMBER_SELECTOR, exclude);
        Collection<Member> members = this.node.getClusterService().getMembers(selector);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    private Collection<MemberGroup> createMemberGroups() {
        Collection<Member> members = this.node.getClusterService().getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        return this.memberGroupFactory.createMemberGroups(members);
    }

    boolean initializePartitionAssignments(Set<Address> excludedAddresses) {
        ClusterState clusterState = this.node.getClusterService().getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            this.logger.warning("Partitions can't be assigned since cluster-state= " + (Object)((Object)clusterState));
            return false;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedAddresses);
        if (memberGroups.isEmpty()) {
            this.logger.warning("No member group is available to assign partition ownership...");
            return false;
        }
        this.logger.info("Initializing cluster partition table arrangement...");
        Address[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions);
        if (newState.length != this.partitionCount) {
            throw new HazelcastException("Invalid partition count! Expected: " + this.partitionCount + ", Actual: " + newState.length);
        }
        this.stateVersion.incrementAndGet();
        clusterState = this.node.getClusterService().getClusterState();
        if (clusterState != ClusterState.ACTIVE) {
            this.stateVersion.decrementAndGet();
            this.logger.warning("Partitions can't be assigned since cluster-state= " + (Object)((Object)clusterState));
            return false;
        }
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            Address[] replicas = newState[partitionId];
            partition.setReplicaAddresses(replicas);
        }
        this.initialized = true;
        return true;
    }

    void setInitialState(Address[][] newState, int partitionStateVersion) {
        if (this.initialized) {
            throw new IllegalStateException("Partition table is already initialized!");
        }
        this.logger.info("Setting cluster partition table ...");
        boolean foundReplica = false;
        for (int partitionId = 0; partitionId < this.partitionCount; ++partitionId) {
            InternalPartitionImpl partition = this.partitions[partitionId];
            Address[] replicas = newState[partitionId];
            if (!foundReplica && replicas != null) {
                for (int i = 0; i < 7; ++i) {
                    foundReplica |= replicas[i] != null;
                }
            }
            partition.setInitialReplicaAddresses(replicas);
        }
        this.stateVersion.set(partitionStateVersion);
        this.initialized = foundReplica;
    }

    void updateMemberGroupsSize() {
        Collection<MemberGroup> groups = this.createMemberGroups();
        int size = 0;
        for (MemberGroup group : groups) {
            if (group.size() <= 0) continue;
            ++size;
        }
        this.memberGroupsSize = size;
    }

    int getMemberGroupsSize() {
        int size = this.memberGroupsSize;
        if (size > 0) {
            return size;
        }
        return this.node.isLiteMember() ? 0 : 1;
    }

    void removeUnknownAddresses() {
        ClusterServiceImpl clusterService = this.node.getClusterService();
        for (InternalPartitionImpl partition : this.partitions) {
            for (int i = 0; i < 7; ++i) {
                MemberImpl member;
                Address address = partition.getReplicaAddress(i);
                if (address == null || (member = clusterService.getMember(address)) != null) continue;
                partition.setReplicaAddress(i, null);
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest("PartitionId=" + partition.getPartitionId() + " " + address + " is removed from replica index: " + i + ", partition: " + partition);
            }
        }
    }

    boolean isAbsentInPartitionTable(Address address) {
        for (InternalPartitionImpl partition : this.partitions) {
            if (!partition.isOwnerOrBackup(address)) continue;
            return false;
        }
        return true;
    }

    boolean isPresentInPartitionTable(Address address) {
        return !this.isAbsentInPartitionTable(address);
    }

    InternalPartition[] getPartitions() {
        return this.partitions;
    }

    public InternalPartition[] getPartitionsCopy() {
        NopPartitionListener listener = new NopPartitionListener();
        InternalPartition[] result = new InternalPartition[this.partitions.length];
        for (int i = 0; i < this.partitionCount; ++i) {
            result[i] = this.partitions[i].copy(listener);
        }
        return result;
    }

    public InternalPartitionImpl getPartitionImpl(int partitionId) {
        return this.partitions[partitionId];
    }

    Address[][] repartition(Set<Address> excludedAddresses) {
        if (!this.initialized) {
            return null;
        }
        Collection<MemberGroup> memberGroups = this.createMemberGroups(excludedAddresses);
        Address[][] newState = this.partitionStateGenerator.arrange(memberGroups, this.partitions);
        if (newState == null && this.logger.isFinestEnabled()) {
            this.logger.finest("Partition rearrangement failed. Number of member groups: " + memberGroups.size());
        }
        return newState;
    }

    public void setMigratingFlag(int partitionId) {
        this.partitions[partitionId].setMigrating(true);
    }

    public void clearMigratingFlag(int partitionId) {
        this.partitions[partitionId].setMigrating(false);
    }

    void updateReplicaAddresses(int partitionId, Address[] replicaAddresses) {
        InternalPartitionImpl partition = this.partitions[partitionId];
        partition.setReplicaAddresses(replicaAddresses);
    }

    void setVersion(int version) {
        this.stateVersion.set(version);
    }

    public int getVersion() {
        return this.stateVersion.get();
    }

    void incrementVersion(int delta) {
        if (delta >= 0) {
            this.stateVersion.addAndGet(delta);
        } else {
            this.logger.warning("partition table version not incremented by " + delta);
        }
    }

    void incrementVersion() {
        this.stateVersion.incrementAndGet();
    }

    void setInitialized() {
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void reset() {
        this.initialized = false;
        this.stateVersion.set(0);
        for (InternalPartitionImpl partition : this.partitions) {
            partition.reset();
        }
    }
}

