/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildInfo {
    public static final int UNKNOWN_HAZELCAST_VERSION = -1;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+)(\\.([\\d]+))?(\\-[\\w]+)?(\\-SNAPSHOT)?$");
    private static final int MAJOR_VERSION_MULTIPLIER = 10000;
    private static final int MINOR_VERSION_MULTIPLIER = 100;
    private static final int PATCH_GROUP_COUNT = 4;
    private final String version;
    private final String build;
    private final String revision;
    private final int buildNumber;
    private final boolean enterprise;
    private final byte serializationVersion;

    public BuildInfo(String version, String build, String revision, int buildNumber, boolean enterprise, byte serializationVersion) {
        this.version = version;
        this.build = build;
        this.revision = revision;
        this.buildNumber = buildNumber;
        this.enterprise = enterprise;
        this.serializationVersion = serializationVersion;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuild() {
        return this.build;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public byte getSerializationVersion() {
        return this.serializationVersion;
    }

    public static int calculateVersion(String version) {
        if (null == version) {
            return -1;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            try {
                String patchVersionString;
                int calculatedVersion = 10000 * Integer.parseInt(matcher.group(1)) + 100 * Integer.parseInt(matcher.group(2));
                int groupCount = matcher.groupCount();
                if (groupCount >= 4 && null != (patchVersionString = matcher.group(4)) && !patchVersionString.startsWith("-")) {
                    calculatedVersion += Integer.parseInt(patchVersionString);
                }
                return calculatedVersion;
            }
            catch (Exception e) {
                Logger.getLogger(BuildInfo.class).warning("Failed to calculate version using version string " + version, e);
            }
        }
        return -1;
    }

    public String toString() {
        return "BuildInfo{version='" + this.version + '\'' + ", build='" + this.build + '\'' + ", buildNumber=" + this.buildNumber + ", revision=" + this.revision + ", enterprise=" + this.enterprise + ", serializationVersion=" + this.serializationVersion + '}';
    }
}

