/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.config.MapAttributeConfig;
import com.hazelcast.query.extractor.ValueExtractor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class ExtractorHelper {
    private static final String NO_SQUARE_BRACKETS_EXP = "[^\\Q[]\\E]";
    private static final String SQUARE_BRACKETS_EXP = "\\[([^\\Q[]\\E])*\\]";
    private static final Pattern EXTRACTOR_ARGS_PATTERN = Pattern.compile(String.format("^(%s)+%s$", "[^\\Q[]\\E]", "\\[([^\\Q[]\\E])*\\]"));
    private static final Pattern COLLECTION_ARGS_PATTERN = Pattern.compile(String.format("^((%s)+(%s){0,1})+$", "[^\\Q[]\\E]", "\\[([^\\Q[]\\E])*\\]"));

    private ExtractorHelper() {
    }

    static Map<String, ValueExtractor> instantiateExtractors(List<MapAttributeConfig> mapAttributeConfigs) {
        HashMap<String, ValueExtractor> extractors = new HashMap<String, ValueExtractor>();
        for (MapAttributeConfig config : mapAttributeConfigs) {
            if (extractors.containsKey(config.getName())) {
                throw new IllegalArgumentException("Could not add " + config + ". Extractor for this attribute name already added.");
            }
            extractors.put(config.getName(), ExtractorHelper.instantiateExtractor(config));
        }
        return extractors;
    }

    static ValueExtractor instantiateExtractor(MapAttributeConfig config) {
        try {
            Class<?> clazz = Class.forName(config.getExtractor());
            Object extractor = clazz.newInstance();
            if (extractor instanceof ValueExtractor) {
                return (ValueExtractor)extractor;
            }
            throw new IllegalArgumentException("Extractor does not extend ValueExtractor class " + config);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
    }

    @Nullable
    static String extractArgumentsFromAttributeName(String attributeNameWithArguments) {
        int start = attributeNameWithArguments.lastIndexOf(91);
        int end = attributeNameWithArguments.lastIndexOf(93);
        if (EXTRACTOR_ARGS_PATTERN.matcher(attributeNameWithArguments).matches()) {
            return attributeNameWithArguments.substring(start + 1, end);
        }
        if (start < 0 && end < 0) {
            return null;
        }
        throw new IllegalArgumentException("Wrong argument input passed to extractor " + attributeNameWithArguments);
    }

    static String extractAttributeNameNameWithoutArguments(String attributeNameWithArguments) {
        if (EXTRACTOR_ARGS_PATTERN.matcher(attributeNameWithArguments).matches()) {
            int start = attributeNameWithArguments.lastIndexOf(91);
            return attributeNameWithArguments.substring(0, start);
        }
        if (COLLECTION_ARGS_PATTERN.matcher(attributeNameWithArguments).matches()) {
            return attributeNameWithArguments;
        }
        throw new IllegalArgumentException("Wrong argument input passed to extractor " + attributeNameWithArguments);
    }
}

