/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.instance.GroupProperty;
import com.hazelcast.instance.HazelcastProperty;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public abstract class HazelcastProperties {
    private final String[] properties = this.createProperties();

    protected abstract String[] createProperties();

    protected void initProperties(Properties properties, HazelcastProperty[] hazelcastProperties) {
        for (HazelcastProperty property : hazelcastProperties) {
            GroupProperty parent;
            String propertyValue;
            String configValue;
            String string = configValue = properties != null ? properties.getProperty(property.getName()) : null;
            this.properties[property.getIndex()] = configValue != null ? configValue : ((propertyValue = property.getSystemProperty()) != null ? propertyValue : ((parent = property.getParent()) != null ? this.properties[parent.ordinal()] : property.getDefaultValue()));
        }
    }

    public String getString(HazelcastProperty groupProperty) {
        return this.properties[groupProperty.getIndex()];
    }

    public boolean getBoolean(HazelcastProperty groupProperty) {
        return Boolean.valueOf(this.properties[groupProperty.getIndex()]);
    }

    public int getInteger(HazelcastProperty groupProperty) {
        return Integer.parseInt(this.properties[groupProperty.getIndex()]);
    }

    public long getLong(HazelcastProperty groupProperty) {
        return Long.parseLong(this.properties[groupProperty.getIndex()]);
    }

    public float getFloat(HazelcastProperty groupProperty) {
        return Float.valueOf(this.properties[groupProperty.getIndex()]).floatValue();
    }

    public long getNanos(HazelcastProperty groupProperty) {
        TimeUnit timeUnit = groupProperty.getTimeUnit();
        return timeUnit.toNanos(this.getLong(groupProperty));
    }

    public long getMillis(HazelcastProperty groupProperty) {
        TimeUnit timeUnit = groupProperty.getTimeUnit();
        return timeUnit.toMillis(this.getLong(groupProperty));
    }

    public int getSeconds(HazelcastProperty groupProperty) {
        TimeUnit timeUnit = groupProperty.getTimeUnit();
        return (int)timeUnit.toSeconds(this.getLong(groupProperty));
    }

    public <E extends Enum> E getEnum(GroupProperty groupProperty, Class<E> enumClazz) {
        String value = this.getString(groupProperty);
        for (Enum enumConstant : (Enum[])enumClazz.getEnumConstants()) {
            if (!enumConstant.name().equalsIgnoreCase(value)) continue;
            return (E)enumConstant;
        }
        throw new IllegalArgumentException(String.format("value '%s' for property '%s' is not a valid %s value", value, groupProperty.getName(), enumClazz.getName()));
    }
}

