/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl.discovery;

import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.integration.DiscoveryService;
import java.util.HashMap;
import java.util.Map;

public class DiscoveryAddressTranslator
implements AddressTranslator {
    private final DiscoveryService discoveryService;
    private volatile Map<Address, Address> privateToPublic;

    public DiscoveryAddressTranslator(DiscoveryService discoveryService) {
        this.discoveryService = discoveryService;
    }

    @Override
    public Address translate(Address address) {
        if (address == null) {
            return null;
        }
        boolean alreadyRefreshed = false;
        Map<Address, Address> privateToPublic = this.privateToPublic;
        if (privateToPublic == null) {
            this.refresh();
            alreadyRefreshed = true;
        }
        privateToPublic = this.privateToPublic;
        Address publicAddress = privateToPublic.get(address);
        if (!alreadyRefreshed) {
            this.refresh();
            privateToPublic = this.privateToPublic;
            publicAddress = privateToPublic.get(address);
        }
        return publicAddress != null ? publicAddress : address;
    }

    @Override
    public void refresh() {
        Iterable<DiscoveryNode> discoveredNodes = this.discoveryService.discoverNodes();
        HashMap<Address, Address> privateToPublic = new HashMap<Address, Address>();
        for (DiscoveryNode discoveryNode : discoveredNodes) {
            privateToPublic.put(discoveryNode.getPrivateAddress(), discoveryNode.getPublicAddress());
        }
        this.privateToPublic = privateToPublic;
    }
}

