/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connection.nio;

import com.hazelcast.client.connection.nio.AbstractClientSelectionHandler;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.tcp.nonblocking.NonBlockingIOThread;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class ClientWriteHandler
extends AbstractClientSelectionHandler
implements Runnable {
    private final Queue<ClientMessage> writeQueue = new ConcurrentLinkedQueue<ClientMessage>();
    private final AtomicBoolean informSelector = new AtomicBoolean(true);
    private final ByteBuffer buffer;
    private boolean ready;
    private ClientMessage lastMessage;
    private volatile long lastHandle;

    public ClientWriteHandler(ClientConnection connection, NonBlockingIOThread ioThread, int bufferSize) {
        super(connection, ioThread);
        this.buffer = ByteBuffer.allocate(bufferSize);
    }

    @Override
    public void handle() throws Exception {
        this.lastHandle = Clock.currentTimeMillis();
        if (!this.connection.isAlive()) {
            return;
        }
        if (this.lastMessage == null) {
            this.lastMessage = this.poll();
        }
        if (this.lastMessage == null && this.buffer.position() == 0) {
            this.ready = true;
            return;
        }
        this.writeBuffer();
        this.ready = false;
        this.registerWrite();
    }

    private void writeBuffer() throws IOException {
        boolean complete;
        while (this.buffer.hasRemaining() && this.lastMessage != null && (complete = this.lastMessage.writeTo(this.buffer))) {
            this.lastMessage = this.poll();
        }
        if (this.buffer.position() == 0) {
            return;
        }
        this.buffer.flip();
        this.socketChannel.write(this.buffer);
        if (this.buffer.hasRemaining()) {
            this.buffer.compact();
        } else {
            this.buffer.clear();
        }
    }

    public void enqueue(OutboundFrame frame) {
        this.writeQueue.offer((ClientMessage)frame);
        if (this.informSelector.compareAndSet(true, false)) {
            this.register();
        }
    }

    private ClientMessage poll() {
        return this.writeQueue.poll();
    }

    @Override
    public void run() {
        try {
            this.informSelector.set(true);
            if (this.ready) {
                this.handle();
            } else {
                this.registerWrite();
            }
            this.ready = false;
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    private void registerWrite() {
        this.registerOp(4);
    }

    @Override
    public void shutdown() {
        this.writeQueue.clear();
    }

    long getLastHandle() {
        return this.lastHandle;
    }
}

